/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _BINARYCHECKSUMHANDLER_H_
#define _BINARYCHECKSUMHANDLER_H_
#pragma once

#include <OSGConfig.h>
#include <OSGBase.h>
#include <OSGBaseTypes.h>
#include <OSGException.h>
#include <OSGBaseFunctions.h>
#include <OSGBinaryDataHandler.h>

#include <cstdint>
#include <string>
#include <vector>

OSG_BEGIN_NAMESPACE

#define ROL(x, n) (((x) << (n)) | ((x) >> (32-(n))))


class OSG_BASE_DLLMAPPING BinaryChecksumHandler : public BinaryDataHandler
{
public:
    BinaryChecksumHandler(void);
    virtual ~BinaryChecksumHandler();

    void write(MemoryHandle mem, SizeT size) override;

    inline unsigned int getChecksum(void)
    {
        flush();
        return _crc;
    }

    //static unsigned int calcFNV1AJesteress(const void* data, size_t length, unsigned int previousCrc32);
    static std::uint32_t calcCrc32c(const std::uint8_t *data, std::size_t size, std::uint32_t previousCrc = 0);

private:
    std::vector<UInt8> _write_memory;

    unsigned int _crc;
    unsigned int _size;

    BinaryChecksumHandler(const BinaryChecksumHandler &source);
    void operator =(const BinaryChecksumHandler &source);
};


OSG_END_NAMESPACE

#endif