/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGCONFIG_H_
#define _OSGCONFIG_H_

#pragma once

#ifdef __hpux
#include <sys/types.h>
#endif

/*-------------------------------------------------------------------------*/
/*                                Versioning                               */

/*! @name Version Defines
 */

/*!{*/

/*! The printable Version string. Includes the full version with specifiers,
    e.g. "1.3.0pre1"
 */

#define OSG_VERSION_STRING      "1.8.1Alpha"

/*! The numeric full version, with two digits per major/minor/release, e.g.
    010300
 */

#define OSG_VERSION             0x010801

/*! The numeric major version number, e.g. 1
 */

#define OSG_MAJOR_VERSION       1

/*! The numeric minor version number, e.g. 4
 */

#define OSG_MINOR_VERSION       8

/*! The numeric release version number, e.g. 0
 */

#define OSG_RELEASE_VERSION     1


/*!}*/

// Mac Hack

#ifdef __APPLE__
#define darwin
#endif

/*-------------------------------------------------------------------------*/
/*                              endian general                             */

#if defined(__sgi)
#include <standards.h>
#include <sys/endian.h>
// Some systems (notably VRJuggler) screw up the environment, so kludge it
#  ifndef BYTE_ORDER
#    define LITTLE_ENDIAN  _LITTLE_ENDIAN
#    define BIG_ENDIAN     _BIG_ENDIAN
#    define BYTE_ORDER     _BYTE_ORDER
#  endif
#elif defined(__hpux)
#include <arpa/nameser.h>
#include <pthread.h>
#elif defined(__sun)
#include <arpa/nameser_compat.h>
#elif defined(__APPLE__)
#include <machine/endian.h>
#elif defined(__linux)
#include <endian.h>
#ifndef __USE_BSD
# define LITTLE_ENDIAN  __LITTLE_ENDIAN
# define BIG_ENDIAN     __BIG_ENDIAN
# define PDP_ENDIAN     __PDP_ENDIAN
# define BYTE_ORDER     __BYTE_ORDER
#endif
#elif defined(WIN32) // HACK until I find a better solution
#define LITTLE_ENDIAN 1234
#define BIG_ENDIAN 4321
#define BYTE_ORDER LITTLE_ENDIAN
#else
#error Endian determination : could not guess your plattform
#endif


/*-------------------------------------------------------------------------*/
/*                              icc general                                */


#ifdef __ICL
#ifndef __INTEL_COMPILER
#define __INTEL_COMPILER __ICL
#endif
#endif


/*-------------------------------------------------------------------------*/
/*                              gcc general                                */


# ifdef __GNUC__

/*! \brief compiler supports namespaces
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_NAMESPACE

/*! \brief compiler supports std namespace
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_STD_NAMESPACE

/*! \brief stream->rdbuf get the new buffer as a parameter
 *  \ingroup GrpBaseDefines
 */

# define OSG_STREAM_RDBUF_HAS_PARAM

/*! \brief stream->isopen is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_STREAM_HAS_ISOPEN

/*! \brief vsnprintf is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_VSNPRINTF

/*! \brief nilbuffer is defined in the stdlib
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_NILBUF

/*! \brief LongLong constants have LL suffix
 *  \ingroup GrpBaseDefines
 */

# define OSG_LONGLONG_HAS_LL

# if __GNUC__ >= 3
#    define OSG_HASH_MAP_AS_EXT

     /*! \brief SGI's stl implementation is available
      *  \ingroup GrpBaseDefines
      */

#    define OSG_SGI_STL

#    define OSG_THROW_NOTHING() throw()

#    define OSG_STDEXCEPTION_NAMESPACE    std

#    if __GNUC__ >= 4 || __GNUC_MINOR__ >=1
#        define OSG_STDEXTENSION_NAMESPACE  __gnu_cxx
#        define OSG_HAS_SSTREAM
#    else
#        define OSG_STDEXTENSION_NAMESPACE  std
#    endif

#    define OSG_STL_HAS_HASH_MAP

# else
#     define OSG_THROW_NOTHING()
#     if __GNUC_MINOR__ <= 96
#         define OSG_GCC_NO_IOS_BASE
#     endif
# endif

# endif


/*-------------------------------------------------------------------------*/
/*                              sgi CC                                     */

# if defined(__sgi) && !defined(__GNUC__)

# if _COMPILER_VERSION < 730
# error compiler version < 730 not supported, please upgrade
# endif

/*! \brief compiler supports namespaces
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_NAMESPACE

/*! \brief compiler supports std namespace
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_STD_NAMESPACE

# if defined(_STANDARD_C_PLUS_PLUS)

# endif  /* _STANDARD_C_PLUS_PLUS */

/*! \brief stream->rdbuf get the new buffer as a parameter
 *  \ingroup GrpBaseDefines
 */

# define OSG_STREAM_RDBUF_HAS_PARAM

/*! \brief stream->isopen is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_STREAM_HAS_ISOPEN

/*! \brief vsnprintf is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_VSNPRINTF

/*! \brief nilbuffer is defined in the stdlib
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_NILBUF

/*! \brief Use SGI internal types to define OpenSG base types
 *  \ingroup GrpBaseDefines
 */

# define OSG_SGI_TYPES

/*! \brief atan2f function available
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_ATANF2

/*! \brief General float math
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_FLOATMATH

/*! \brief SGI's stl implementation is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_SGI_STL

# define OSG_STL_HAS_HASH_MAP

/*! \brief Use GLX
 *  \ingroup GrpBaseDefines
 */

# define OSG_USE_GLX

/*! \brief LongLong constants have LL suffix
 *  \ingroup GrpBaseDefines
 */

# define OSG_LONGLONG_HAS_LL

# define OSG_THROW_NOTHING() THROW_NOTHING()

# define OSG_SGI_CC

# define OSG_FOUND_OS

# define OSG_STDEXCEPTION_NAMESPACE std

# endif // defined(__sgi) && !defined(__GNUC__)




/*-------------------------------------------------------------------------*/
/*                              Linux gcc                                  */

# if defined(__GNUC__) && defined(__linux)

/*! \brief streams in std namespace
 *  \ingroup GrpBaseDefines
 */

# define OSG_LINUX_TYPES

# define OSG_HAS_ATANF2

# define OSG_HAS_FLOATMATH


/*! \brief Use the math functions from the std:: namespace
 *  \ingroup GrpBaseDefines
    The std:: namespace has a set of overloaded functions for many
    math operations, up to and including long double versions.
 */

# define OSG_USE_STDMATH

# define OSG_USE_GLX

# define OSG_USE_PTHREADS

# define OSG_LINUX_GCC

# define OSG_FOUND_OS

# define GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)

# endif // defined(__GNUC__) && defined(__linux)

/*-------------------------------------------------------------------------*/
/*                              Linux gcc ia64                             */

# if defined(__GNUC__) && defined(__linux) && defined(__ia64)

# define SIZE_T_NEQ_UINT32

# endif // defined(__GNUC__) && defined(__linux) && defined(__ia64)

/*-------------------------------------------------------------------------*/
/*                              Linux icc                                  */

# if defined(__INTEL_COMPILER) && defined(__linux)

# ifndef __ICL
#    define __ICL __INTEL_COMPILER
# endif

# ifndef __INTEL_COMPILER_VERSION
#    define __INTEL_COMPILER_VERSION __INTEL_COMPILER
# endif

# define OSG_HAS_NAMESPACE

# define OSG_HAS_STD_NAMESPACE

# define OSG_STREAM_RDBUF_HAS_PARAM

# define OSG_STREAM_HAS_IOPEN

# define OSG_HAS_NILBUF

# define OSG_LINUX_TYPES

# define OSG_HAS_ATANF2

# define OSG_HAS_FLOATMATH

# define OSG_USE_STDMATH

# define OSG_USE_GLX

# define OSG_LONGLONG_HAS_LL

# if __INTEL_COMPILER_VERSION >= 710
#     define OSG_THROW_NOTHING() throw()
# else
#     define OSG_THROW_NOTHING()
# endif

// # define OSG_NO_INT8_PNT This works fine now. Why prevent it? DR

# define OSG_USE_PTHREADS

# define OSG_LINUX_ICC

# define OSG_FOUND_OS

// icc >=8.1 uses gnu headers anyway, use gnu defines set above
#if __INTEL_COMPILER_VERSION < 810 || ! defined(__GNUC__)
# define OSG_STDEXTENSION_NAMESPACE std
# define OSG_STDEXCEPTION_NAMESPACE std
#endif

# define OSG_STL_HAS_HASH_MAP

# define OSG_HAS_SSTREAM

# define OSG_HAS_VSNPRINTF

# if __INTEL_COMPILER_VERSION >= 800
# define OSG_USE_HASH_COMPARE
# endif

#if defined(__GNUC__)
#if __INTEL_COMPILER_VERSION >= 900 && __GNUC__ >= 4
#define __builtin_powi(x,i) pow(x, i)
#define __builtin_powif(x,i) pow(x, i)
#define __builtin_powil(x,i) pow(x, i)
#endif
#endif

# endif // defined(__INTEL_COMPILER) && defined(__linux)

# if defined(__INTEL_COMPILER) && defined(__linux) && defined(__ia64)

# define OSG_NO_INT8_PNT

# endif // defined(__GNUC__) && defined(__linux) && defined(__ia64)

/*-------------------------------------------------------------------------*/
/*                              Windows icc                                */
#if 0
// intel compiler with vc6 headers.
# if defined(__INTEL_COMPILER) && !defined(__linux) && defined(_MSC_VER) && _MSC_VER < 1300

# ifndef __ICL
#    define __ICL __INTEL_COMPILER
# endif

// Use windows internal types to define OpenSG base types
# define OSG_WIN_TYPES

// Use windows threads
# define OSG_USE_WINTHREADS

// compiler supports namespaces
# define OSG_HAS_NAMESPACE

// compiler supports std namespace
# define OSG_HAS_STD_NAMESPACE

// general float math
# define OSG_HAS_FLOATMATH

// Use WGL
# define OSG_USE_WGL

# define OSG_STREAM_HAS_ISOPEN

// it's there, it's just called something else
# define OSG_HAS_VSNPRINTF
# define vsnprintf _vsnprintf

# define OSG_HAS_NILBUF
# define OSG_STREAM_RDBUF_HAS_PARAM

# define OSG_LONGLONG_HAS_LL

# define OSG_THROW_NOTHING()

# define OSG_WIN32_ICL

# define OSG_FOUND_OS

# endif // defined(__INTEL_COMPILER) && !defined(__linux)
#endif
/*-------------------------------------------------------------------------*/
/*                              Windows vc7/8                              */

// vc7/8 and icl9/10 (with vc8 headers)
# if (defined(_MSC_VER) && (_MSC_VER >= 1300)) || defined(__INTEL_COMPILER)

# define OSG_SPEZ_IMPL_DLLMAPPING
// Use windows internal types to define OpenSG base types
# define OSG_WIN_TYPES
// compiler supports namespaces
# define OSG_HAS_NAMESPACE
// Use windows threads
# define OSG_USE_WINTHREADS
// compiler supports std namespace
# define OSG_HAS_STD_NAMESPACE
// general float math
# define OSG_HAS_FLOATMATH

// HACK need this for the x64 build on windows with the platform sdk compiler
// it uses the old vc 6.0 headers. amz
# ifndef OSG_PSDK_COMPILER
# define OSG_USE_STDMATH
# endif

# define OSG_STREAM_HAS_ISOPEN

// it's there, it's just called something else
# define OSG_HAS_VSNPRINTF
// vc 9.0 finally supports vsnprintf!
# if _MSC_VER < 1500
# define vsnprintf _vsnprintf
# endif

# define OSG_HAS_NILBUF
# define OSG_STREAM_RDBUF_HAS_PARAM

# define OSG_MICROSOFT_COMPILER_ALERT
# define OSG_MICROSOFT_COMPILER_HACKS
// Use WGL
# define OSG_USE_WGL

//# define OSG_HAS_TEMPLATE_RETURNVALUES

# define OSG_NEED_EXPLICIT_INST_FOR_STATIC

# define OSG_THROW_NOTHING()

# define OSG_WIN32_CL

# define OSG_FOUND_OS

# if _MSC_VER >= 1300 && _MSC_VER < 1310
#    define OSG_WIN32_CL_NET70 1
# endif

# if _MSC_VER > 1300
# define OSG_NEED_BOOL_MFIELD_SPEZ
# endif

// vc 8.0
# if _MSC_VER >= 1400
# define OSG_STDEXCEPTION_NAMESPACE std
# endif

# endif // defined(_MSC_VER) && !defined(__ICL)

/*-------------------------------------------------------------------------*/
/*                              Mac OSX gcc                                */

# if defined(__APPLE__)

# define darwin

# define OSG_LINUX_TYPES
# define OSG_NO_CONCEPT_CHECKS
# define SIZE_T_NEQ_UINT32
# include <AvailabilityMacros.h>
//# if !defined(MAC_OS_X_VERSION_10_5) || (MAC_OS_X_VERSION_MAX_ALLOWED < MAC_OS_X_VERSION_10_5)
//#  define OSG_GLENUM_NEQ_UINT32
//# endif

# define OSG_USE_PTHREADS

# define OSG_DLSYM_NEEDS_UNDERSCORE

# define OSG_USE_STDMATH

#define OSG_FOUND_OS

# define GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)

# endif // if defined(__APPLE__)

/*-------------------------------------------------------------------------*/
/*                              HP-UX gcc-64                               */

#if defined(__hpux) && defined(__GNUC__)
/*! \brief streams in std namespace
 *  \ingroup GrpBaseDefines
 */

# define OSG_HPUX_TYPES

# define OSG_USE_PTHREADS

# define OSG_FOUND_OS

#endif

/*-------------------------------------------------------------------------*/
/*                               HP-UX aC++                                */

# if defined(__hpux) && !defined(__GNUC__)

/*! \brief compiler supports namespaces
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_NAMESPACE

/*! \brief compiler supports std namespace
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_STD_NAMESPACE

# if defined(_STANDARD_C_PLUS_PLUS)

# endif  /* _STANDARD_C_PLUS_PLUS */

/*! \brief stream->rdbuf get the new buffer as a parameter
 *  \ingroup GrpBaseDefines
 */

# define OSG_STREAM_RDBUF_HAS_PARAM

/*! \brief stream->isopen is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_STREAM_HAS_ISOPEN

/*! \brief vsnprintf is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_VSNPRINTF

/*! \brief nilbuffer is defined in the stdlib
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_NILBUF

/*! \brief Use SGI internal types to define OpenSG base types
 *  \ingroup GrpBaseDefines
 */

# define OSG_HPUX_TYPES

/*! \brief atan2f function available
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_ATANF2

/*! \brief General float math
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_FLOATMATH

# define OSG_USE_STDMATH

/*! \brief SGI's stl implementation is available
 *  \ingroup GrpBaseDefines
 */

//# define OSG_SGI_STL

/*! \brief Use GLX
 *  \ingroup GrpBaseDefines
 */

# define OSG_USE_GLX

/*! \brief LongLong constants have LL suffix
 *  \ingroup GrpBaseDefines
 */

# define OSG_LONGLONG_HAS_LL

# define OSG_THROW_NOTHING() __THROWSPEC_NULL

# define OSG_USE_PTHREADS

# define OSG_HPUX_ACC

# define OSG_FOUND_OS

// # define OSG_NOGLUTSUBDIR

# define OSG_STDEXCEPTION_NAMESPACE std

# endif // defined(__hpux) && !defined(__GNUC__)


/*-------------------------------------------------------------------------*/
/*                               Sun CC                                    */

# if defined(__sun) && !defined(__GNUC__)

/*! \brief compiler supports namespaces
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_NAMESPACE

/*! \brief compiler supports std namespace
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_STD_NAMESPACE

# if defined(_STANDARD_C_PLUS_PLUS)

# endif  /* _STANDARD_C_PLUS_PLUS */

/*! \brief stream->rdbuf get the new buffer as a parameter
 *  \ingroup GrpBaseDefines
 */

# define OSG_STREAM_RDBUF_HAS_PARAM

/*! \brief stream->isopen is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_STREAM_HAS_ISOPEN

/*! \brief vsnprintf is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_VSNPRINTF

/*! \brief nilbuffer is defined in the stdlib
 *  \ingroup GrpBaseDefines
 */

# define OSG_HAS_NILBUF

/*! \brief Use SGI internal types to define OpenSG base types
 *  \ingroup GrpBaseDefines
 */

# define OSG_SUN_TYPES

/*! \brief atan2f function available
 *  \ingroup GrpBaseDefines
 */

//# define OSG_HAS_ATANF2

/*! \brief General float math
 *  \ingroup GrpBaseDefines
 */

//# define OSG_HAS_FLOATMATH

# define OSG_USE_STDMATH

/*! \brief SGI's stl implementation is available
 *  \ingroup GrpBaseDefines
 */

# define OSG_SGI_STL

/*! \brief Use GLX
 *  \ingroup GrpBaseDefines
 */

# define OSG_USE_GLX

/*! \brief LongLong constants have LL suffix
 *  \ingroup GrpBaseDefines
 */

# define OSG_LONGLONG_HAS_LL

# define OSG_THROW_NOTHING() throw()

# define OSG_USE_PTHREADS

# define OSG_SUN_CC

# define OSG_FOUND_OS

# define OSG_NO_INT8_PNT

// # define OSG_NOGLUTSUBDIR

# define OSG_STDEXCEPTION_NAMESPACE std

# endif // defined(__sun) && !defined(__GNUC__)


#ifndef OSG_FOUND_OS
# error Could not determine compiler / os combination
#endif


/* Mixed bag defines... */

// Enable printf macros used in OSGBaseTypeTraits.h
#if defined(OSG_LINUX_TYPES) && !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif

// STLPORT doesn't support all of std::math
#if defined(STLPORT) ||defined(OSG_WITH_STLPORT)
#undef OSG_USE_STDMATH
#endif



#if defined(OSG_HAS_STD_NAMESPACE)
# define OSG_USING_STD_NAMESPACE namespace std {} using namespace std;
# define OSG_STD std
#endif

#if defined(OSG_HAS_NAMESPACE)

/*! @name Namespace Defines
 */

/*@{*/

/** \brief osg namespace, use to reference a object within the namespace, like
 *  \ingroup GrpBaseDefines
    osg::OSGUInt32.
*/

/** \brief Begin the osg namespace
 *  \ingroup GrpBaseDefines
 */

# define OSG_BEGIN_NAMESPACE namespace osg {

/** \brief End the osg namespace
 *  \ingroup GrpBaseDefines
 */

# define OSG_END_NAMESPACE }

/** \brief Use the osg namespace throughout the following code.
 *  \ingroup GrpBaseDefines
 */

# define OSG_USING_NAMESPACE namespace osg {} using namespace osg;

/*@}*/

# else /* OSG_HAS_NAMESPACE */

# define OSG_BEGIN_NAMESPACE
# define OSG_END_NAMESPACE
# define OSG_USING_NAMESPACE

#endif /*  */


#if defined(OSG_DLSYM_NEEDS_UNDERSCORE)
#define OSG_DLSYM_UNDERSCORE "_"
#else
#define OSG_DLSYM_UNDERSCORE
#endif

#define OSG_COMPILETIME_NUM_ASPECTS

#define OSG_NUM_ASPECTS 1


#ifdef OSG_WIN_TYPES
#ifndef OSG_NO_WINDOWD_H_INCLUDE
#include <windows.h>
#endif
#endif

#ifndef OSG_WIN_TYPES
#define OSG_APIENTRY
#else
#ifdef APIENTRY
#define OSG_APIENTRY APIENTRY
#elif defined(GLAPIENTRY)
#define OSG_APIENTRY GLAPIENTRY
#else
#error "Neither APIENTRY nor GLAPIENTRY defined"
#endif
#endif

#ifdef OSG_DEBUG
#define OSG_DEBUG_LOCK_STAT
#endif

#ifdef OSG_DEBUG_ARG
#define OSG_CHECK_ARG(ARG) ARG
#else
#define OSG_CHECK_ARG(ARG)
#endif

#ifdef OSG_DEBUG
#define OSG_DEBUG_CHECK_ARG(ARG) ARG
#else
#define OSG_DEBUG_CHECK_ARG(ARG)
#endif


#include <OSGBase.h>
#include <OSGExportDefines.h>

#include <OSGConfigured.h>

#if defined(OSG_DEBUG_NO_FCPTR_ARITHM)
# if defined(OSG_NUM_ASPECTS)
#  undef OSG_NUM_ASPECTS
# endif
# define OSG_NUM_ASPECTS 1
#endif

#define OSG_ASSERT(expr) assert(expr)

//#define OSG_DBG_MEM
//#define OSG_DBG_LCK

// ToBeChecked Defaults

#if !defined(OSG_STDEXCEPTION_NAMESPACE)
#    define OSG_STDEXCEPTION_NAMESPACE
#endif

#ifndef OSG_STDEXTENSION_NAMESPACE
#    define OSG_STDEXTENSION_NAMESPACE  std
#endif

#if !defined(OSG_DOC_LEVEL)
#    define OSG_DOC_LEVEL 0
#endif

#define OSG_FLEX_USE_IOSTREAM_INPUT 1

#if defined(OSG_ICC_GNU_COMPAT)

# undef OSG_USE_HASH_COMPARE

# if __GNUC__ >= 3
#    define OSG_HASH_MAP_AS_EXT

     /*! \brief SGI's stl implementation is available
      *  \ingroup GrpBaseDefines
      */
#    ifdef OSG_STDEXTENSION_NAMESPACE
#        undef OSG_STDEXTENSION_NAMESPACE
#    endif

#    if __GNUC__ >= 4 || __GNUC_MINOR__ >=1
#        define OSG_STDEXTENSION_NAMESPACE  __gnu_cxx
#    else
#        define OSG_STDEXTENSION_NAMESPACE  std
#    endif
# endif
#endif

#include <inttypes.h>
// for std::ptrdiff_t
#include <cstddef>

typedef unsigned int OSGGLenum;
typedef unsigned char OSGGLboolean;
typedef unsigned int OSGGLbitfield;
typedef signed char OSGGLbyte;
typedef short OSGGLshort;
typedef int OSGGLint;
typedef int OSGGLsizei;
typedef unsigned char OSGGLubyte;
typedef unsigned short OSGGLushort;
typedef unsigned int OSGGLuint;
typedef float OSGGLfloat;
typedef double OSGGLdouble;
typedef float OSGGLclampf;
typedef void OSGGLvoid;
typedef ptrdiff_t OSGGLintptr;
typedef ptrdiff_t OSGGLsizeiptr;
typedef uint64_t OSGGLuint64;
typedef int64_t OSGGLint64;

#define OSG_GL_BYTE                           0x1400
#define OSG_GL_UNSIGNED_BYTE                  0x1401
#define OSG_GL_SHORT                          0x1402
#define OSG_GL_UNSIGNED_SHORT                 0x1403
#define OSG_GL_INT                            0x1404
#define OSG_GL_UNSIGNED_INT                   0x1405
#define OSG_GL_FLOAT                          0x1406
#define OSG_GL_2_BYTES                        0x1407
#define OSG_GL_3_BYTES                        0x1408
#define OSG_GL_4_BYTES                        0x1409
#define OSG_GL_DOUBLE                         0x140A
#define OSG_GL_HALF_FLOAT_NV                  0x140B

#define OSG_GL_ZERO 0
#define OSG_GL_FALSE 0
#define OSG_GL_LOGIC_OP 0x0BF1
#define OSG_GL_NONE 0
#define OSG_GL_TEXTURE_COMPONENTS 0x1003
#define OSG_GL_NO_ERROR 0
#define OSG_GL_POINTS 0x0000
#define OSG_GL_CURRENT_BIT 0x00000001
#define OSG_GL_TRUE 1
#define OSG_GL_ONE 1
#define OSG_GL_CLIENT_PIXEL_STORE_BIT 0x00000001
#define OSG_GL_LINES 0x0001
#define OSG_GL_LINE_LOOP 0x0002
#define OSG_GL_POINT_BIT 0x00000002
#define OSG_GL_CLIENT_VERTEX_ARRAY_BIT 0x00000002
#define OSG_GL_LINE_STRIP 0x0003
#define OSG_GL_LINE_BIT 0x00000004
#define OSG_GL_TRIANGLES 0x0004
#define OSG_GL_TRIANGLE_STRIP 0x0005
#define OSG_GL_TRIANGLE_FAN 0x0006
#define OSG_GL_QUADS 0x0007
#define OSG_GL_QUAD_STRIP 0x0008
#define OSG_GL_POLYGON_BIT 0x00000008
#define OSG_GL_POLYGON 0x0009
#define OSG_GL_POLYGON_STIPPLE_BIT 0x00000010
#define OSG_GL_PIXEL_MODE_BIT 0x00000020
#define OSG_GL_LIGHTING_BIT 0x00000040
#define OSG_GL_FOG_BIT 0x00000080
#define OSG_GL_DEPTH_BUFFER_BIT 0x00000100
#define OSG_GL_ACCUM 0x0100
#define OSG_GL_LOAD 0x0101
#define OSG_GL_RETURN 0x0102
#define OSG_GL_MULT 0x0103
#define OSG_GL_ADD 0x0104
#define OSG_GL_NEVER 0x0200
#define OSG_GL_ACCUM_BUFFER_BIT 0x00000200
#define OSG_GL_LESS 0x0201
#define OSG_GL_EQUAL 0x0202
#define OSG_GL_LEQUAL 0x0203
#define OSG_GL_GREATER 0x0204
#define OSG_GL_NOTEQUAL 0x0205
#define OSG_GL_GEQUAL 0x0206
#define OSG_GL_ALWAYS 0x0207
#define OSG_GL_SRC_COLOR 0x0300
#define OSG_GL_ONE_MINUS_SRC_COLOR 0x0301
#define OSG_GL_SRC_ALPHA 0x0302
#define OSG_GL_ONE_MINUS_SRC_ALPHA 0x0303
#define OSG_GL_DST_ALPHA 0x0304
#define OSG_GL_ONE_MINUS_DST_ALPHA 0x0305
#define OSG_GL_DST_COLOR 0x0306
#define OSG_GL_ONE_MINUS_DST_COLOR 0x0307
#define OSG_GL_SRC_ALPHA_SATURATE 0x0308
#define OSG_GL_STENCIL_BUFFER_BIT 0x00000400
#define OSG_GL_FRONT_LEFT 0x0400
#define OSG_GL_FRONT_RIGHT 0x0401
#define OSG_GL_BACK_LEFT 0x0402
#define OSG_GL_BACK_RIGHT 0x0403
#define OSG_GL_FRONT 0x0404
#define OSG_GL_BACK 0x0405
#define OSG_GL_LEFT 0x0406
#define OSG_GL_RIGHT 0x0407
#define OSG_GL_FRONT_AND_BACK 0x0408
#define OSG_GL_AUX0 0x0409
#define OSG_GL_AUX1 0x040A
#define OSG_GL_AUX2 0x040B
#define OSG_GL_AUX3 0x040C
#define OSG_GL_INVALID_ENUM 0x0500
#define OSG_GL_INVALID_VALUE 0x0501
#define OSG_GL_INVALID_OPERATION 0x0502
#define OSG_GL_STACK_OVERFLOW 0x0503
#define OSG_GL_STACK_UNDERFLOW 0x0504
#define OSG_GL_OUT_OF_MEMORY 0x0505
#define OSG_GL_2D 0x0600
#define OSG_GL_3D 0x0601
#define OSG_GL_3D_COLOR 0x0602
#define OSG_GL_3D_COLOR_TEXTURE 0x0603
#define OSG_GL_4D_COLOR_TEXTURE 0x0604
#define OSG_GL_PASS_THROUGH_TOKEN 0x0700
#define OSG_GL_POINT_TOKEN 0x0701
#define OSG_GL_LINE_TOKEN 0x0702
#define OSG_GL_POLYGON_TOKEN 0x0703
#define OSG_GL_BITMAP_TOKEN 0x0704
#define OSG_GL_DRAW_PIXEL_TOKEN 0x0705
#define OSG_GL_COPY_PIXEL_TOKEN 0x0706
#define OSG_GL_LINE_RESET_TOKEN 0x0707
#define OSG_GL_EXP 0x0800
#define OSG_GL_VIEWPORT_BIT 0x00000800
#define OSG_GL_EXP2 0x0801
#define OSG_GL_CW 0x0900
#define OSG_GL_CCW 0x0901
#define OSG_GL_COEFF 0x0A00
#define OSG_GL_ORDER 0x0A01
#define OSG_GL_DOMAIN 0x0A02
#define OSG_GL_CURRENT_COLOR 0x0B00
#define OSG_GL_CURRENT_INDEX 0x0B01
#define OSG_GL_CURRENT_NORMAL 0x0B02
#define OSG_GL_CURRENT_TEXTURE_COORDS 0x0B03
#define OSG_GL_CURRENT_RASTER_COLOR 0x0B04
#define OSG_GL_CURRENT_RASTER_INDEX 0x0B05
#define OSG_GL_CURRENT_RASTER_TEXTURE_COORDS 0x0B06
#define OSG_GL_CURRENT_RASTER_POSITION 0x0B07
#define OSG_GL_CURRENT_RASTER_POSITION_VALID 0x0B08
#define OSG_GL_CURRENT_RASTER_DISTANCE 0x0B09
#define OSG_GL_POINT_SMOOTH 0x0B10
#define OSG_GL_POINT_SIZE 0x0B11
#define OSG_GL_POINT_SIZE_RANGE 0x0B12
#define OSG_GL_POINT_SIZE_GRANULARITY 0x0B13
#define OSG_GL_LINE_SMOOTH 0x0B20
#define OSG_GL_LINE_WIDTH 0x0B21
#define OSG_GL_LINE_WIDTH_RANGE 0x0B22
#define OSG_GL_LINE_WIDTH_GRANULARITY 0x0B23
#define OSG_GL_LINE_STIPPLE 0x0B24
#define OSG_GL_LINE_STIPPLE_PATTERN 0x0B25
#define OSG_GL_LINE_STIPPLE_REPEAT 0x0B26
#define OSG_GL_LIST_MODE 0x0B30
#define OSG_GL_MAX_LIST_NESTING 0x0B31
#define OSG_GL_LIST_BASE 0x0B32
#define OSG_GL_LIST_INDEX 0x0B33
#define OSG_GL_POLYGON_MODE 0x0B40
#define OSG_GL_POLYGON_SMOOTH 0x0B41
#define OSG_GL_POLYGON_STIPPLE 0x0B42
#define OSG_GL_EDGE_FLAG 0x0B43
#define OSG_GL_CULL_FACE 0x0B44
#define OSG_GL_CULL_FACE_MODE 0x0B45
#define OSG_GL_FRONT_FACE 0x0B46
#define OSG_GL_LIGHTING 0x0B50
#define OSG_GL_LIGHT_MODEL_LOCAL_VIEWER 0x0B51
#define OSG_GL_LIGHT_MODEL_TWO_SIDE 0x0B52
#define OSG_GL_LIGHT_MODEL_AMBIENT 0x0B53
#define OSG_GL_SHADE_MODEL 0x0B54
#define OSG_GL_COLOR_MATERIAL_FACE 0x0B55
#define OSG_GL_COLOR_MATERIAL_PARAMETER 0x0B56
#define OSG_GL_COLOR_MATERIAL 0x0B57
#define OSG_GL_FOG 0x0B60
#define OSG_GL_FOG_INDEX 0x0B61
#define OSG_GL_FOG_DENSITY 0x0B62
#define OSG_GL_FOG_START 0x0B63
#define OSG_GL_FOG_END 0x0B64
#define OSG_GL_FOG_MODE 0x0B65
#define OSG_GL_FOG_COLOR 0x0B66
#define OSG_GL_DEPTH_RANGE 0x0B70
#define OSG_GL_DEPTH_TEST 0x0B71
#define OSG_GL_DEPTH_WRITEMASK 0x0B72
#define OSG_GL_DEPTH_CLEAR_VALUE 0x0B73
#define OSG_GL_DEPTH_FUNC 0x0B74
#define OSG_GL_ACCUM_CLEAR_VALUE 0x0B80
#define OSG_GL_STENCIL_TEST 0x0B90
#define OSG_GL_STENCIL_CLEAR_VALUE 0x0B91
#define OSG_GL_STENCIL_FUNC 0x0B92
#define OSG_GL_STENCIL_VALUE_MASK 0x0B93
#define OSG_GL_STENCIL_FAIL 0x0B94
#define OSG_GL_STENCIL_PASS_DEPTH_FAIL 0x0B95
#define OSG_GL_STENCIL_PASS_DEPTH_PASS 0x0B96
#define OSG_GL_STENCIL_REF 0x0B97
#define OSG_GL_STENCIL_WRITEMASK 0x0B98
#define OSG_GL_MATRIX_MODE 0x0BA0
#define OSG_GL_NORMALIZE 0x0BA1
#define OSG_GL_VIEWPORT 0x0BA2
#define OSG_GL_MODELVIEW_STACK_DEPTH 0x0BA3
#define OSG_GL_PROJECTION_STACK_DEPTH 0x0BA4
#define OSG_GL_TEXTURE_STACK_DEPTH 0x0BA5
#define OSG_GL_MODELVIEW_MATRIX 0x0BA6
#define OSG_GL_PROJECTION_MATRIX 0x0BA7
#define OSG_GL_TEXTURE_MATRIX 0x0BA8
#define OSG_GL_ATTRIB_STACK_DEPTH 0x0BB0
#define OSG_GL_CLIENT_ATTRIB_STACK_DEPTH 0x0BB1
#define OSG_GL_ALPHA_TEST 0x0BC0
#define OSG_GL_ALPHA_TEST_FUNC 0x0BC1
#define OSG_GL_ALPHA_TEST_REF 0x0BC2
#define OSG_GL_DITHER 0x0BD0
#define OSG_GL_BLEND_DST 0x0BE0
#define OSG_GL_BLEND_SRC 0x0BE1
#define OSG_GL_BLEND 0x0BE2
#define OSG_GL_LOGIC_OP_MODE 0x0BF0
#define OSG_GL_INDEX_LOGIC_OP 0x0BF1
#define OSG_GL_COLOR_LOGIC_OP 0x0BF2
#define OSG_GL_AUX_BUFFERS 0x0C00
#define OSG_GL_DRAW_BUFFER 0x0C01
#define OSG_GL_READ_BUFFER 0x0C02
#define OSG_GL_SCISSOR_BOX 0x0C10
#define OSG_GL_SCISSOR_TEST 0x0C11
#define OSG_GL_INDEX_CLEAR_VALUE 0x0C20
#define OSG_GL_INDEX_WRITEMASK 0x0C21
#define OSG_GL_COLOR_CLEAR_VALUE 0x0C22
#define OSG_GL_COLOR_WRITEMASK 0x0C23
#define OSG_GL_INDEX_MODE 0x0C30
#define OSG_GL_RGBA_MODE 0x0C31
#define OSG_GL_DOUBLEBUFFER 0x0C32
#define OSG_GL_STEREO 0x0C33
#define OSG_GL_RENDER_MODE 0x0C40
#define OSG_GL_PERSPECTIVE_CORRECTION_HINT 0x0C50
#define OSG_GL_POINT_SMOOTH_HINT 0x0C51
#define OSG_GL_LINE_SMOOTH_HINT 0x0C52
#define OSG_GL_POLYGON_SMOOTH_HINT 0x0C53
#define OSG_GL_FOG_HINT 0x0C54
#define OSG_GL_TEXTURE_GEN_S 0x0C60
#define OSG_GL_TEXTURE_GEN_T 0x0C61
#define OSG_GL_TEXTURE_GEN_R 0x0C62
#define OSG_GL_TEXTURE_GEN_Q 0x0C63
#define OSG_GL_PIXEL_MAP_I_TO_I 0x0C70
#define OSG_GL_PIXEL_MAP_S_TO_S 0x0C71
#define OSG_GL_PIXEL_MAP_I_TO_R 0x0C72
#define OSG_GL_PIXEL_MAP_I_TO_G 0x0C73
#define OSG_GL_PIXEL_MAP_I_TO_B 0x0C74
#define OSG_GL_PIXEL_MAP_I_TO_A 0x0C75
#define OSG_GL_PIXEL_MAP_R_TO_R 0x0C76
#define OSG_GL_PIXEL_MAP_G_TO_G 0x0C77
#define OSG_GL_PIXEL_MAP_B_TO_B 0x0C78
#define OSG_GL_PIXEL_MAP_A_TO_A 0x0C79
#define OSG_GL_PIXEL_MAP_I_TO_I_SIZE 0x0CB0
#define OSG_GL_PIXEL_MAP_S_TO_S_SIZE 0x0CB1
#define OSG_GL_PIXEL_MAP_I_TO_R_SIZE 0x0CB2
#define OSG_GL_PIXEL_MAP_I_TO_G_SIZE 0x0CB3
#define OSG_GL_PIXEL_MAP_I_TO_B_SIZE 0x0CB4
#define OSG_GL_PIXEL_MAP_I_TO_A_SIZE 0x0CB5
#define OSG_GL_PIXEL_MAP_R_TO_R_SIZE 0x0CB6
#define OSG_GL_PIXEL_MAP_G_TO_G_SIZE 0x0CB7
#define OSG_GL_PIXEL_MAP_B_TO_B_SIZE 0x0CB8
#define OSG_GL_PIXEL_MAP_A_TO_A_SIZE 0x0CB9
#define OSG_GL_UNPACK_SWAP_BYTES 0x0CF0
#define OSG_GL_UNPACK_LSB_FIRST 0x0CF1
#define OSG_GL_UNPACK_ROW_LENGTH 0x0CF2
#define OSG_GL_UNPACK_SKIP_ROWS 0x0CF3
#define OSG_GL_UNPACK_SKIP_PIXELS 0x0CF4
#define OSG_GL_UNPACK_ALIGNMENT 0x0CF5
#define OSG_GL_PACK_SWAP_BYTES 0x0D00
#define OSG_GL_PACK_LSB_FIRST 0x0D01
#define OSG_GL_PACK_ROW_LENGTH 0x0D02
#define OSG_GL_PACK_SKIP_ROWS 0x0D03
#define OSG_GL_PACK_SKIP_PIXELS 0x0D04
#define OSG_GL_PACK_ALIGNMENT 0x0D05
#define OSG_GL_MAP_COLOR 0x0D10
#define OSG_GL_MAP_STENCIL 0x0D11
#define OSG_GL_INDEX_SHIFT 0x0D12
#define OSG_GL_INDEX_OFFSET 0x0D13
#define OSG_GL_RED_SCALE 0x0D14
#define OSG_GL_RED_BIAS 0x0D15
#define OSG_GL_ZOOM_X 0x0D16
#define OSG_GL_ZOOM_Y 0x0D17
#define OSG_GL_GREEN_SCALE 0x0D18
#define OSG_GL_GREEN_BIAS 0x0D19
#define OSG_GL_BLUE_SCALE 0x0D1A
#define OSG_GL_BLUE_BIAS 0x0D1B
#define OSG_GL_ALPHA_SCALE 0x0D1C
#define OSG_GL_ALPHA_BIAS 0x0D1D
#define OSG_GL_DEPTH_SCALE 0x0D1E
#define OSG_GL_DEPTH_BIAS 0x0D1F
#define OSG_GL_MAX_EVAL_ORDER 0x0D30
#define OSG_GL_MAX_LIGHTS 0x0D31
#define OSG_GL_MAX_CLIP_PLANES 0x0D32
#define OSG_GL_MAX_TEXTURE_SIZE 0x0D33
#define OSG_GL_MAX_PIXEL_MAP_TABLE 0x0D34
#define OSG_GL_MAX_ATTRIB_STACK_DEPTH 0x0D35
#define OSG_GL_MAX_MODELVIEW_STACK_DEPTH 0x0D36
#define OSG_GL_MAX_NAME_STACK_DEPTH 0x0D37
#define OSG_GL_MAX_PROJECTION_STACK_DEPTH 0x0D38
#define OSG_GL_MAX_TEXTURE_STACK_DEPTH 0x0D39
#define OSG_GL_MAX_VIEWPORT_DIMS 0x0D3A
#define OSG_GL_MAX_CLIENT_ATTRIB_STACK_DEPTH 0x0D3B
#define OSG_GL_SUBPIXEL_BITS 0x0D50
#define OSG_GL_INDEX_BITS 0x0D51
#define OSG_GL_RED_BITS 0x0D52
#define OSG_GL_GREEN_BITS 0x0D53
#define OSG_GL_BLUE_BITS 0x0D54
#define OSG_GL_ALPHA_BITS 0x0D55
#define OSG_GL_DEPTH_BITS 0x0D56
#define OSG_GL_STENCIL_BITS 0x0D57
#define OSG_GL_ACCUM_RED_BITS 0x0D58
#define OSG_GL_ACCUM_GREEN_BITS 0x0D59
#define OSG_GL_ACCUM_BLUE_BITS 0x0D5A
#define OSG_GL_ACCUM_ALPHA_BITS 0x0D5B
#define OSG_GL_NAME_STACK_DEPTH 0x0D70
#define OSG_GL_AUTO_NORMAL 0x0D80
#define OSG_GL_MAP1_COLOR_4 0x0D90
#define OSG_GL_MAP1_INDEX 0x0D91
#define OSG_GL_MAP1_NORMAL 0x0D92
#define OSG_GL_MAP1_TEXTURE_COORD_1 0x0D93
#define OSG_GL_MAP1_TEXTURE_COORD_2 0x0D94
#define OSG_GL_MAP1_TEXTURE_COORD_3 0x0D95
#define OSG_GL_MAP1_TEXTURE_COORD_4 0x0D96
#define OSG_GL_MAP1_VERTEX_3 0x0D97
#define OSG_GL_MAP1_VERTEX_4 0x0D98
#define OSG_GL_MAP2_COLOR_4 0x0DB0
#define OSG_GL_MAP2_INDEX 0x0DB1
#define OSG_GL_MAP2_NORMAL 0x0DB2
#define OSG_GL_MAP2_TEXTURE_COORD_1 0x0DB3
#define OSG_GL_MAP2_TEXTURE_COORD_2 0x0DB4
#define OSG_GL_MAP2_TEXTURE_COORD_3 0x0DB5
#define OSG_GL_MAP2_TEXTURE_COORD_4 0x0DB6
#define OSG_GL_MAP2_VERTEX_3 0x0DB7
#define OSG_GL_MAP2_VERTEX_4 0x0DB8
#define OSG_GL_MAP1_GRID_DOMAIN 0x0DD0
#define OSG_GL_MAP1_GRID_SEGMENTS 0x0DD1
#define OSG_GL_MAP2_GRID_DOMAIN 0x0DD2
#define OSG_GL_MAP2_GRID_SEGMENTS 0x0DD3
#define OSG_GL_TEXTURE_1D 0x0DE0
#define OSG_GL_TEXTURE_2D 0x0DE1
#define OSG_GL_FEEDBACK_BUFFER_POINTER 0x0DF0
#define OSG_GL_FEEDBACK_BUFFER_SIZE 0x0DF1
#define OSG_GL_FEEDBACK_BUFFER_TYPE 0x0DF2
#define OSG_GL_SELECTION_BUFFER_POINTER 0x0DF3
#define OSG_GL_SELECTION_BUFFER_SIZE 0x0DF4
#define OSG_GL_TEXTURE_WIDTH 0x1000
#define OSG_GL_TRANSFORM_BIT 0x00001000
#define OSG_GL_TEXTURE_HEIGHT 0x1001
#define OSG_GL_TEXTURE_INTERNAL_FORMAT 0x1003
#define OSG_GL_TEXTURE_BORDER_COLOR 0x1004
#define OSG_GL_TEXTURE_BORDER 0x1005
#define OSG_GL_DONT_CARE 0x1100
#define OSG_GL_FASTEST 0x1101
#define OSG_GL_NICEST 0x1102
#define OSG_GL_AMBIENT 0x1200
#define OSG_GL_DIFFUSE 0x1201
#define OSG_GL_SPECULAR 0x1202
#define OSG_GL_POSITION 0x1203
#define OSG_GL_SPOT_DIRECTION 0x1204
#define OSG_GL_SPOT_EXPONENT 0x1205
#define OSG_GL_SPOT_CUTOFF 0x1206
#define OSG_GL_CONSTANT_ATTENUATION 0x1207
#define OSG_GL_LINEAR_ATTENUATION 0x1208
#define OSG_GL_QUADRATIC_ATTENUATION 0x1209
#define OSG_GL_COMPILE 0x1300
#define OSG_GL_COMPILE_AND_EXECUTE 0x1301
#define OSG_GL_BYTE 0x1400
#define OSG_GL_UNSIGNED_BYTE 0x1401
#define OSG_GL_SHORT 0x1402
#define OSG_GL_UNSIGNED_SHORT 0x1403
#define OSG_GL_INT 0x1404
#define OSG_GL_UNSIGNED_INT 0x1405
#define OSG_GL_FLOAT 0x1406
#define OSG_GL_2_BYTES 0x1407
#define OSG_GL_3_BYTES 0x1408
#define OSG_GL_4_BYTES 0x1409
#define OSG_GL_DOUBLE 0x140A
#define OSG_GL_CLEAR 0x1500
#define OSG_GL_AND 0x1501
#define OSG_GL_AND_REVERSE 0x1502
#define OSG_GL_COPY 0x1503
#define OSG_GL_AND_INVERTED 0x1504
#define OSG_GL_NOOP 0x1505
#define OSG_GL_XOR 0x1506
#define OSG_GL_OR 0x1507
#define OSG_GL_NOR 0x1508
#define OSG_GL_EQUIV 0x1509
#define OSG_GL_INVERT 0x150A
#define OSG_GL_OR_REVERSE 0x150B
#define OSG_GL_COPY_INVERTED 0x150C
#define OSG_GL_OR_INVERTED 0x150D
#define OSG_GL_NAND 0x150E
#define OSG_GL_SET 0x150F
#define OSG_GL_EMISSION 0x1600
#define OSG_GL_SHININESS 0x1601
#define OSG_GL_AMBIENT_AND_DIFFUSE 0x1602
#define OSG_GL_COLOR_INDEXES 0x1603
#define OSG_GL_MODELVIEW 0x1700
#define OSG_GL_PROJECTION 0x1701
#define OSG_GL_TEXTURE 0x1702
#define OSG_GL_COLOR 0x1800
#define OSG_GL_DEPTH 0x1801
#define OSG_GL_STENCIL 0x1802
#define OSG_GL_COLOR_INDEX 0x1900
#define OSG_GL_STENCIL_INDEX 0x1901
#define OSG_GL_DEPTH_COMPONENT 0x1902
#define OSG_GL_RED 0x1903
#define OSG_GL_GREEN 0x1904
#define OSG_GL_BLUE 0x1905
#define OSG_GL_ALPHA 0x1906
#define OSG_GL_RGB 0x1907
#define OSG_GL_RGBA 0x1908
#define OSG_GL_BGR 0x80E0
#define OSG_GL_BGRA 0x80E1
#define OSG_GL_LUMINANCE 0x1909
#define OSG_GL_LUMINANCE_ALPHA 0x190A
#define OSG_GL_BITMAP 0x1A00
#define OSG_GL_POINT 0x1B00
#define OSG_GL_LINE 0x1B01
#define OSG_GL_FILL 0x1B02
#define OSG_GL_RENDER 0x1C00
#define OSG_GL_FEEDBACK 0x1C01
#define OSG_GL_SELECT 0x1C02
#define OSG_GL_FLAT 0x1D00
#define OSG_GL_SMOOTH 0x1D01
#define OSG_GL_KEEP 0x1E00
#define OSG_GL_REPLACE 0x1E01
#define OSG_GL_INCR 0x1E02
#define OSG_GL_DECR 0x1E03
#define OSG_GL_VENDOR 0x1F00
#define OSG_GL_RENDERER 0x1F01
#define OSG_GL_VERSION 0x1F02
#define OSG_GL_EXTENSIONS 0x1F03
#define OSG_GL_S 0x2000
#define OSG_GL_ENABLE_BIT 0x00002000
#define OSG_GL_T 0x2001
#define OSG_GL_R 0x2002
#define OSG_GL_Q 0x2003
#define OSG_GL_MODULATE 0x2100
#define OSG_GL_DECAL 0x2101
#define OSG_GL_TEXTURE_ENV_MODE 0x2200
#define OSG_GL_TEXTURE_ENV_COLOR 0x2201
#define OSG_GL_TEXTURE_ENV 0x2300
#define OSG_GL_EYE_LINEAR 0x2400
#define OSG_GL_OBJECT_LINEAR 0x2401
#define OSG_GL_SPHERE_MAP 0x2402
#define OSG_GL_TEXTURE_GEN_MODE 0x2500
#define OSG_GL_OBJECT_PLANE 0x2501
#define OSG_GL_EYE_PLANE 0x2502
#define OSG_GL_NEAREST 0x2600
#define OSG_GL_LINEAR 0x2601
#define OSG_GL_NEAREST_MIPMAP_NEAREST 0x2700
#define OSG_GL_LINEAR_MIPMAP_NEAREST 0x2701
#define OSG_GL_NEAREST_MIPMAP_LINEAR 0x2702
#define OSG_GL_LINEAR_MIPMAP_LINEAR 0x2703
#define OSG_GL_TEXTURE_MAG_FILTER 0x2800
#define OSG_GL_TEXTURE_MIN_FILTER 0x2801
#define OSG_GL_TEXTURE_WRAP_S 0x2802
#define OSG_GL_TEXTURE_WRAP_T 0x2803
#define OSG_GL_CLAMP 0x2900
#define OSG_GL_REPEAT 0x2901
#define OSG_GL_POLYGON_OFFSET_UNITS 0x2A00
#define OSG_GL_POLYGON_OFFSET_POINT 0x2A01
#define OSG_GL_POLYGON_OFFSET_LINE 0x2A02
#define OSG_GL_R3_G3_B2 0x2A10
#define OSG_GL_V2F 0x2A20
#define OSG_GL_V3F 0x2A21
#define OSG_GL_C4UB_V2F 0x2A22
#define OSG_GL_C4UB_V3F 0x2A23
#define OSG_GL_C3F_V3F 0x2A24
#define OSG_GL_N3F_V3F 0x2A25
#define OSG_GL_C4F_N3F_V3F 0x2A26
#define OSG_GL_T2F_V3F 0x2A27
#define OSG_GL_T4F_V4F 0x2A28
#define OSG_GL_T2F_C4UB_V3F 0x2A29
#define OSG_GL_T2F_C3F_V3F 0x2A2A
#define OSG_GL_T2F_N3F_V3F 0x2A2B
#define OSG_GL_T2F_C4F_N3F_V3F 0x2A2C
#define OSG_GL_T4F_C4F_N3F_V4F 0x2A2D
#define OSG_GL_CLIP_PLANE0 0x3000
#define OSG_GL_CLIP_PLANE1 0x3001
#define OSG_GL_CLIP_PLANE2 0x3002
#define OSG_GL_CLIP_PLANE3 0x3003
#define OSG_GL_CLIP_PLANE4 0x3004
#define OSG_GL_CLIP_PLANE5 0x3005
#define OSG_GL_CLIP_DISTANCE0 OSG_GL_CLIP_PLANE0
#define OSG_GL_CLIP_DISTANCE1 OSG_GL_CLIP_PLANE1
#define OSG_GL_CLIP_DISTANCE2 OSG_GL_CLIP_PLANE2
#define OSG_GL_CLIP_DISTANCE3 OSG_GL_CLIP_PLANE3
#define OSG_GL_CLIP_DISTANCE4 OSG_GL_CLIP_PLANE4
#define OSG_GL_CLIP_DISTANCE5 OSG_GL_CLIP_PLANE5
#define OSG_GL_PROGRAM_POINT_SIZE 0x8642
#define OSG_GL_MULTISAMPLE 0x809D
#define OSG_GL_DEBUG_OUTPUT 0x92E0
#define OSG_GL_DEBUG_OUTPUT_SYNCHRONOUS 0x8242
#define OSG_GL_SAMPLE_ALPHA_TO_COVERAGE 0x809E
#define OSG_GL_SAMPLE_ALPHA_TO_ONE 0x809F
#define OSG_GL_SAMPLE_COVERAGE 0x80A0
#define OSG_GL_SAMPLE_SHADING 0x8C36
#define OSG_GL_SAMPLE_MASK 0x8E51
#define OSG_GL_TEXTURE_CUBE_MAP_SEAMLESS 0x884F
#define OSG_GL_DEPTH_CLAMP 0x864F
#define OSG_GL_FRAMEBUFFER_SRGB 0x8DB9
#define OSG_GL_PRIMITIVE_RESTART 0x8F9D
#define OSG_GL_PRIMITIVE_RESTART_FIXED_INDEX 0x8D69
#define OSG_GL_RASTERIZER_DISCARD 0x8C89
#define OSG_GL_LIGHT0 0x4000
#define OSG_GL_COLOR_BUFFER_BIT 0x00004000
#define OSG_GL_LIGHT1 0x4001
#define OSG_GL_LIGHT2 0x4002
#define OSG_GL_LIGHT3 0x4003
#define OSG_GL_LIGHT4 0x4004
#define OSG_GL_LIGHT5 0x4005
#define OSG_GL_LIGHT6 0x4006
#define OSG_GL_LIGHT7 0x4007
#define OSG_GL_HINT_BIT 0x00008000
#define OSG_GL_POLYGON_OFFSET_FILL 0x8037
#define OSG_GL_POLYGON_OFFSET_FACTOR 0x8038
#define OSG_GL_ALPHA4 0x803B
#define OSG_GL_ALPHA8 0x803C
#define OSG_GL_ALPHA12 0x803D
#define OSG_GL_ALPHA16 0x803E
#define OSG_GL_LUMINANCE4 0x803F
#define OSG_GL_LUMINANCE8 0x8040
#define OSG_GL_LUMINANCE12 0x8041
#define OSG_GL_LUMINANCE16 0x8042
#define OSG_GL_LUMINANCE4_ALPHA4 0x8043
#define OSG_GL_LUMINANCE6_ALPHA2 0x8044
#define OSG_GL_LUMINANCE8_ALPHA8 0x8045
#define OSG_GL_LUMINANCE12_ALPHA4 0x8046
#define OSG_GL_LUMINANCE12_ALPHA12 0x8047
#define OSG_GL_LUMINANCE16_ALPHA16 0x8048
#define OSG_GL_INTENSITY 0x8049
#define OSG_GL_INTENSITY4 0x804A
#define OSG_GL_INTENSITY8 0x804B
#define OSG_GL_INTENSITY12 0x804C
#define OSG_GL_INTENSITY16 0x804D
#define OSG_GL_RGB4 0x804F
#define OSG_GL_RGB5 0x8050
#define OSG_GL_RGB8 0x8051
#define OSG_GL_RGB10 0x8052
#define OSG_GL_RGB12 0x8053
#define OSG_GL_RGB16 0x8054
#define OSG_GL_RGBA2 0x8055
#define OSG_GL_RGBA4 0x8056
#define OSG_GL_RGB5_A1 0x8057
#define OSG_GL_RGBA8 0x8058
#define OSG_GL_RGB10_A2 0x8059
#define OSG_GL_RGBA12 0x805A
#define OSG_GL_RGBA16 0x805B
#define OSG_GL_TEXTURE_RED_SIZE 0x805C
#define OSG_GL_TEXTURE_GREEN_SIZE 0x805D
#define OSG_GL_TEXTURE_BLUE_SIZE 0x805E
#define OSG_GL_TEXTURE_ALPHA_SIZE 0x805F
#define OSG_GL_TEXTURE_LUMINANCE_SIZE 0x8060
#define OSG_GL_TEXTURE_INTENSITY_SIZE 0x8061
#define OSG_GL_PROXY_TEXTURE_1D 0x8063
#define OSG_GL_PROXY_TEXTURE_2D 0x8064
#define OSG_GL_TEXTURE_PRIORITY 0x8066
#define OSG_GL_TEXTURE_RESIDENT 0x8067
#define OSG_GL_TEXTURE_BINDING_1D 0x8068
#define OSG_GL_TEXTURE_BINDING_2D 0x8069
#define OSG_GL_VERTEX_ARRAY 0x8074
#define OSG_GL_NORMAL_ARRAY 0x8075
#define OSG_GL_COLOR_ARRAY 0x8076
#define OSG_GL_INDEX_ARRAY 0x8077
#define OSG_GL_TEXTURE_COORD_ARRAY 0x8078
#define OSG_GL_EDGE_FLAG_ARRAY 0x8079
#define OSG_GL_VERTEX_ARRAY_SIZE 0x807A
#define OSG_GL_VERTEX_ARRAY_TYPE 0x807B
#define OSG_GL_VERTEX_ARRAY_STRIDE 0x807C
#define OSG_GL_NORMAL_ARRAY_TYPE 0x807E
#define OSG_GL_NORMAL_ARRAY_STRIDE 0x807F
#define OSG_GL_COLOR_ARRAY_SIZE 0x8081
#define OSG_GL_COLOR_ARRAY_TYPE 0x8082
#define OSG_GL_COLOR_ARRAY_STRIDE 0x8083
#define OSG_GL_INDEX_ARRAY_TYPE 0x8085
#define OSG_GL_INDEX_ARRAY_STRIDE 0x8086
#define OSG_GL_TEXTURE_COORD_ARRAY_SIZE 0x8088
#define OSG_GL_TEXTURE_COORD_ARRAY_TYPE 0x8089
#define OSG_GL_TEXTURE_COORD_ARRAY_STRIDE 0x808A
#define OSG_GL_EDGE_FLAG_ARRAY_STRIDE 0x808C
#define OSG_GL_VERTEX_ARRAY_POINTER 0x808E
#define OSG_GL_NORMAL_ARRAY_POINTER 0x808F
#define OSG_GL_COLOR_ARRAY_POINTER 0x8090
#define OSG_GL_INDEX_ARRAY_POINTER 0x8091
#define OSG_GL_TEXTURE_COORD_ARRAY_POINTER 0x8092
#define OSG_GL_EDGE_FLAG_ARRAY_POINTER 0x8093
#define OSG_GL_COLOR_INDEX1_EXT 0x80E2
#define OSG_GL_COLOR_INDEX2_EXT 0x80E3
#define OSG_GL_COLOR_INDEX4_EXT 0x80E4
#define OSG_GL_COLOR_INDEX8_EXT 0x80E5
#define OSG_GL_COLOR_INDEX12_EXT 0x80E6
#define OSG_GL_COLOR_INDEX16_EXT 0x80E7
#define OSG_GL_EVAL_BIT 0x00010000
#define OSG_GL_LIST_BIT 0x00020000
#define OSG_GL_TEXTURE_BIT 0x00040000
#define OSG_GL_SCISSOR_BIT 0x00080000
#define OSG_GL_ALL_ATTRIB_BITS 0x000fffff
#define OSG_GL_CLIENT_ALL_ATTRIB_BITS 0xffffffff

#define OSG_GL_RGB9_E5 0x8C3D

#define OSG_GL_COMPRESSED_RGB_S3TC_DXT1_EXT 0x83F0
#define OSG_GL_COMPRESSED_RGBA_S3TC_DXT1_EXT 0x83F1
#define OSG_GL_COMPRESSED_RGBA_S3TC_DXT3_EXT 0x83F2
#define OSG_GL_COMPRESSED_RGBA_S3TC_DXT5_EXT 0x83F3

// amz GL_COMPRESSED_RGB_BPTC_UNORM doesn't exist but to reflect the right channels count
// I added my own value for this, we need a non conflicting value
// which we can store as pixel format in our Image class. GLenum is a 32 bit unsigned integer
// but it only uses 16 bits for the value, so we can use the upper 16 bits for our own values!
// 0x5256 ==> "VR" in ASCII
#define OSG_GL_COMPRESSED_RGB_BPTC_UNORM 0x52568E8C // custom value for 3 channel BPTC
#define OSG_GL_COMPRESSED_RGBA_BPTC_UNORM 0x8E8C
#define OSG_GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM 0x8E8D
#define OSG_GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT 0x8E8E
#define OSG_GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT 0x8E8F
#define OSG_GL_COMPRESSED_RGB_ASTC_4x4 0x525693B0 // custom value for 3 channel ASTC
#define OSG_GL_COMPRESSED_RGBA_ASTC_4x4 0x93B0
#define OSG_GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 0x93D0
#define OSG_GL_RGBA32UI_EXT 0x8D70
#define OSG_GL_RGB32UI_EXT 0x8D71
#define OSG_GL_ALPHA32UI_EXT 0x8D72
#define OSG_GL_INTENSITY32UI_EXT 0x8D73
#define OSG_GL_LUMINANCE32UI_EXT 0x8D74
#define OSG_GL_LUMINANCE_ALPHA32UI_EXT 0x8D75
#define OSG_GL_RGBA16UI_EXT 0x8D76
#define OSG_GL_RGB16UI_EXT 0x8D77
#define OSG_GL_ALPHA16UI_EXT 0x8D78
#define OSG_GL_INTENSITY16UI_EXT 0x8D79
#define OSG_GL_LUMINANCE16UI_EXT 0x8D7A
#define OSG_GL_LUMINANCE_ALPHA16UI_EXT 0x8D7B
#define OSG_GL_RGBA8UI_EXT 0x8D7C
#define OSG_GL_RGB8UI_EXT 0x8D7D
#define OSG_GL_ALPHA8UI_EXT 0x8D7E
#define OSG_GL_INTENSITY8UI_EXT 0x8D7F
#define OSG_GL_LUMINANCE8UI_EXT 0x8D80
#define OSG_GL_LUMINANCE_ALPHA8UI_EXT 0x8D81
#define OSG_GL_RGBA32I_EXT 0x8D82
#define OSG_GL_RGB32I_EXT 0x8D83
#define OSG_GL_ALPHA32I_EXT 0x8D84
#define OSG_GL_INTENSITY32I_EXT 0x8D85
#define OSG_GL_LUMINANCE32I_EXT 0x8D86
#define OSG_GL_LUMINANCE_ALPHA32I_EXT 0x8D87
#define OSG_GL_RGBA16I_EXT 0x8D88
#define OSG_GL_RGB16I_EXT 0x8D89
#define OSG_GL_ALPHA16I_EXT 0x8D8A
#define OSG_GL_INTENSITY16I_EXT 0x8D8B
#define OSG_GL_LUMINANCE16I_EXT 0x8D8C
#define OSG_GL_LUMINANCE_ALPHA16I_EXT 0x8D8D
#define OSG_GL_RGBA8I_EXT 0x8D8E
#define OSG_GL_RGB8I_EXT 0x8D8F
#define OSG_GL_ALPHA8I_EXT 0x8D90
#define OSG_GL_INTENSITY8I_EXT 0x8D91
#define OSG_GL_LUMINANCE8I_EXT 0x8D92
#define OSG_GL_LUMINANCE_ALPHA8I_EXT 0x8D93
#define OSG_GL_RED_INTEGER_EXT 0x8D94
#define OSG_GL_GREEN_INTEGER_EXT 0x8D95
#define OSG_GL_BLUE_INTEGER_EXT 0x8D96
#define OSG_GL_ALPHA_INTEGER_EXT 0x8D97
#define OSG_GL_RGB_INTEGER_EXT 0x8D98
#define OSG_GL_RGBA_INTEGER_EXT 0x8D99
#define OSG_GL_BGR_INTEGER_EXT 0x8D9A
#define OSG_GL_BGRA_INTEGER_EXT 0x8D9B
#define OSG_GL_LUMINANCE_INTEGER_EXT 0x8D9C
#define OSG_GL_LUMINANCE_ALPHA_INTEGER_EXT 0x8D9D
#define OSG_GL_RGBA_INTEGER_MODE_EXT 0x8D9E

#define OSG_GL_RGBA16F 0x881A
#define OSG_GL_RGB16F 0x881B
#define OSG_GL_RGBA32F 0x8814
#define OSG_GL_RGB32F 0x8815
#define OSG_GL_RGBA32F_ARB 0x8814
#define OSG_GL_RGB32F_ARB 0x8815
#define OSG_GL_ALPHA32F_ARB 0x8816
#define OSG_GL_INTENSITY32F_ARB 0x8817
#define OSG_GL_LUMINANCE32F_ARB 0x8818
#define OSG_GL_LUMINANCE_ALPHA32F_ARB 0x8819
#define OSG_GL_RGBA16F_ARB 0x881A
#define OSG_GL_RGB16F_ARB 0x881B
#define OSG_GL_ALPHA16F_ARB 0x881C
#define OSG_GL_INTENSITY16F_ARB 0x881D
#define OSG_GL_LUMINANCE16F_ARB 0x881E
#define OSG_GL_LUMINANCE_ALPHA16F_ARB 0x881F
#define OSG_GL_TEXTURE_RED_TYPE_ARB 0x8C10
#define OSG_GL_TEXTURE_GREEN_TYPE_ARB 0x8C11
#define OSG_GL_TEXTURE_BLUE_TYPE_ARB 0x8C12
#define OSG_GL_TEXTURE_ALPHA_TYPE_ARB 0x8C13
#define OSG_GL_TEXTURE_LUMINANCE_TYPE_ARB 0x8C14
#define OSG_GL_TEXTURE_INTENSITY_TYPE_ARB 0x8C15
#define OSG_GL_TEXTURE_DEPTH_TYPE_ARB 0x8C16
#define OSG_GL_UNSIGNED_NORMALIZED_ARB 0x8C17

#define OSG_GL_ABGR_EXT 0x8000
#define OSG_GL_BGR_EXT 0x80E0
#define OSG_GL_BGRA_EXT 0x80E1

#define OSG_GL_CLAMP_TO_BORDER 0x812D
#define OSG_GL_MIRRORED_REPEAT 0x8370
#define OSG_GL_CLAMP_TO_EDGE 0x812F

#define OSG_GL_COLOR_ATTACHMENT0 0x8CE0
#define OSG_GL_COLOR_ATTACHMENT1 0x8CE1
#define OSG_GL_COLOR_ATTACHMENT2 0x8CE2
#define OSG_GL_COLOR_ATTACHMENT3 0x8CE3
#define OSG_GL_COLOR_ATTACHMENT4 0x8CE4
#define OSG_GL_COLOR_ATTACHMENT5 0x8CE5
#define OSG_GL_COLOR_ATTACHMENT6 0x8CE6
#define OSG_GL_COLOR_ATTACHMENT7 0x8CE7
#define OSG_GL_COLOR_ATTACHMENT8 0x8CE8
#define OSG_GL_COLOR_ATTACHMENT9 0x8CE9
#define OSG_GL_COLOR_ATTACHMENT10 0x8CEA
#define OSG_GL_COLOR_ATTACHMENT11 0x8CEB
#define OSG_GL_COLOR_ATTACHMENT12 0x8CEC
#define OSG_GL_COLOR_ATTACHMENT13 0x8CED
#define OSG_GL_COLOR_ATTACHMENT14 0x8CEE
#define OSG_GL_COLOR_ATTACHMENT15 0x8CEF

#define OSG_GL_SRGB                                       0x8C40
#define OSG_GL_SRGB8                                      0x8C41
#define OSG_GL_SRGB_ALPHA                                 0x8C42
#define OSG_GL_SRGB8_ALPHA8                               0x8C43
#define OSG_GL_SLUMINANCE_ALPHA                           0x8C44
#define OSG_GL_SLUMINANCE8_ALPHA8                         0x8C45
#define OSG_GL_SLUMINANCE                                 0x8C46
#define OSG_GL_SLUMINANCE8                                0x8C47
#define OSG_GL_COMPRESSED_SRGB                            0x8C48
#define OSG_GL_COMPRESSED_SRGB_ALPHA                      0x8C49
#define OSG_GL_COMPRESSED_SLUMINANCE                      0x8C4A
#define OSG_GL_COMPRESSED_SLUMINANCE_ALPHA                0x8C4B
#define OSG_GL_COMPRESSED_SRGB_S3TC_DXT1                  0x8C4C
#define OSG_GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1            0x8C4D
#define OSG_GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3            0x8C4E
#define OSG_GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5            0x8C4F


#define OSG_GL_TEXTURE0_ARB                   0x84C0
#define OSG_GL_TEXTURE1_ARB                   0x84C1
#define OSG_GL_TEXTURE2_ARB                   0x84C2
#define OSG_GL_TEXTURE3_ARB                   0x84C3
#define OSG_GL_TEXTURE4_ARB                   0x84C4
#define OSG_GL_TEXTURE5_ARB                   0x84C5
#define OSG_GL_TEXTURE6_ARB                   0x84C6
#define OSG_GL_TEXTURE7_ARB                   0x84C7
#define OSG_GL_TEXTURE8_ARB                   0x84C8
#define OSG_GL_TEXTURE9_ARB                   0x84C9
#define OSG_GL_TEXTURE10_ARB                  0x84CA
#define OSG_GL_TEXTURE11_ARB                  0x84CB
#define OSG_GL_TEXTURE12_ARB                  0x84CC
#define OSG_GL_TEXTURE13_ARB                  0x84CD
#define OSG_GL_TEXTURE14_ARB                  0x84CE
#define OSG_GL_TEXTURE15_ARB                  0x84CF
#define OSG_GL_TEXTURE16_ARB                  0x84D0
#define OSG_GL_TEXTURE17_ARB                  0x84D1
#define OSG_GL_TEXTURE18_ARB                  0x84D2
#define OSG_GL_TEXTURE19_ARB                  0x84D3
#define OSG_GL_TEXTURE20_ARB                  0x84D4
#define OSG_GL_TEXTURE21_ARB                  0x84D5
#define OSG_GL_TEXTURE22_ARB                  0x84D6
#define OSG_GL_TEXTURE23_ARB                  0x84D7
#define OSG_GL_TEXTURE24_ARB                  0x84D8
#define OSG_GL_TEXTURE25_ARB                  0x84D9
#define OSG_GL_TEXTURE26_ARB                  0x84DA
#define OSG_GL_TEXTURE27_ARB                  0x84DB
#define OSG_GL_TEXTURE28_ARB                  0x84DC
#define OSG_GL_TEXTURE29_ARB                  0x84DD
#define OSG_GL_TEXTURE30_ARB                  0x84DE
#define OSG_GL_TEXTURE31_ARB                  0x84DF
#define OSG_GL_ACTIVE_TEXTURE_ARB             0x84E0
#define OSG_GL_CLIENT_ACTIVE_TEXTURE_ARB      0x84E1
#define OSG_GL_MAX_TEXTURE_UNITS_ARB          0x84E2
#endif /* _OSGCONFIG_H_ */
