/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2003 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#include <algorithm>

#include "OSGCrypt.h"

OSG_USING_NAMESPACE

/*!
 * \brief
 * \param
 * \return
 */
Crypt::Crypt(const std::vector<UInt8> &key) :
    _key(key),
    _sbox1(),
    _i(0),
    _j(0)
{
    reset();
}

/*!
 * \brief
 * \param
 * \return
 */
Crypt::~Crypt()
{
}

/*!
 * \brief
 * \param
 * \return
 */
void Crypt::reset(void)
{
    _i = 0;
    _j = 0;

    for(UInt32 i = 0;i < 256U;++i)
        _sbox1[i] = (UInt8) i;

    // initialize the sbox2 with our key.
    UInt8 sbox2[256];
    UInt32 j = 0;
    for(UInt32 i = 0;i < 256U;++i)
    {
        if(j == _key.size())
            j = 0;
        sbox2[i] = _key[j++];
    }

    // scramble sbox1 with sbox2.
    j = 0;
    for(UInt32 i = 0;i < 256;++i)
    {
        j = (j + (UInt32) _sbox1[i] + (UInt32) sbox2[i]) % 256U;
        std::swap(_sbox1[i], _sbox1[j]);
    }
}

/*!
 * \brief
 * \param
 * \return
 */
UInt8 Crypt::code(UInt8 c)
{
    _i = (_i + 1U) % 256U;
    _j = (_j + (UInt32) _sbox1[_i]) % 256U;

    // will repeat itself at a great interval.
    std::swap(_sbox1[_i], _sbox1[_j]);

    // get ready to create pseudo random byte from the encryption key.
    UInt32 t = ((UInt32) _sbox1[_i] + (UInt32) _sbox1[_j]) %  256U;

    // get the random byte.
    UInt8 k = _sbox1[t];

    // xor with the data.
    return (c ^ k);
}
