#include "OSGExternalLog.h"

OSG_BEGIN_NAMESPACE

ExternalLog* ExternalLog::_the = nullptr;

ExternalLog* ExternalLog::log()
{
    if (nullptr == _the)
        _the = new ExternalLog;

    return _the;
}

void ExternalLog::warning(const std::string& text)
{
    if (!_the)
        return;

    for (auto &cb : _callbacks)
        cb("WARNING: " + text);
}

void ExternalLog::info(const std::string& text)
{
    if (!_the)
        return;

    for (auto &cb : _callbacks)
        cb(text);
}

void ExternalLog::error(const std::string& text)
{
    if (!_the)
        return;

    for (auto &cb : _callbacks)
        cb("FATAL: " + text);
}

void ExternalLog::addCallback(Callback cb)
{
    _callbacks.push_back(cb);
}


OSG_END_NAMESPACE