#pragma once

#include <OSGBaseTypes.h>
#include <functional>
#include <string>
#include <vector>

OSG_BEGIN_NAMESPACE

// This class can be used to connect to external logging frameworks

class OSG_BASE_DLLMAPPING ExternalLog
{
public:
    using Callback = std::function<void(std::string)>;

    static ExternalLog* log();

    void warning(const std::string& text);
    void info(const std::string& text);
    void error(const std::string& text);

    void addCallback(Callback cb);

private:
    static ExternalLog* _the;
    std::vector<Callback> _callbacks;
};

OSG_END_NAMESPACE