#include "OSGGL.h"

static std::function<bool(void)> osgMakeCurrentCB = nullptr;
static std::function<void(void)> osgDoneCurrentCB = nullptr;

void registerMakeCurrentCB(std::function<bool(void)> callback)
{
    osgMakeCurrentCB = callback;
}

void registerDoneCurrentCB(std::function<void(void)> callback)
{
    osgDoneCurrentCB = callback;
}

bool osgMakeCurrent()
{
    if(osgMakeCurrentCB != nullptr)
        return osgMakeCurrentCB();
    return false;
}

void osgDoneCurrent()
{
    if (osgDoneCurrentCB != nullptr)
        osgDoneCurrentCB();
}


GLuint* getDefaultLeftFramebufferHandle()
{
    static GLuint* s_defaultRightFramebuffer = new GLuint(0);
    return s_defaultRightFramebuffer;
}

GLuint* getDefaultRightFramebufferHandle()
{
    static GLuint* s_defaultRightFramebuffer = new GLuint(0);
    return s_defaultRightFramebuffer;
}

ViewportStack* getViewportStack()
{
    static ViewportStack* s_viewportStack = new ViewportStack();
    return s_viewportStack;
}

ViewportStack* getScissorStack()
{
    static ViewportStack* s_scissorStack = new ViewportStack();
    return s_scissorStack;
}

BitFlagStack* getBitFlagStack()
{
    static BitFlagStack* s_bitflagStack = new BitFlagStack();
    return s_bitflagStack;
}

FramebufferStack* getFramebufferStack()
{
    static FramebufferStack* s_framebufferStack = new FramebufferStack(0);
    return s_framebufferStack;
}

BufferStack* getDrawBufferStack()
{
    static BufferStack* s_drawBufferStack = new BufferStack(GL_BACK_LEFT);
    return s_drawBufferStack;
}

BufferStack* getReadBufferStack()
{
    static BufferStack* s_readBufferStack = new BufferStack(GL_BACK_LEFT);
    return s_readBufferStack;
}

ColorMaskStack* getColorMaskStack()
{
    static ColorMaskStack* s_colorMaskStack = new ColorMaskStack();
    return s_colorMaskStack;
}

DepthMaskStack* getDepthMaskStack()
{
    static DepthMaskStack* s_depthMaskStack = new DepthMaskStack();
    return s_depthMaskStack;
}

DepthFuncStack* getDepthFuncStack()
{
    static DepthFuncStack* s_depthFuncStack = new DepthFuncStack();
    return s_depthFuncStack;
}

ClearDepthStack* getClearDepthStack()
{
    static ClearDepthStack* s_clearDepthStack = new ClearDepthStack();
    return s_clearDepthStack;
}

ClipControlStack* getClipControlStack()
{
    static ClipControlStack* s_clipControlStack = new ClipControlStack();
    return s_clipControlStack;
}
