/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <math.h>

#include "OSGConfig.h"

#include <assert.h>

#include "OSGLine2D.h"

OSG_USING_NAMESPACE

/*! \class osg::Line2D
     A 2 dimesional line going from p1 to p2
*/


/*-------------------------- constructor ----------------------------------*/

Line2D::Line2D(void) : 
    _p1(0.f, 0.f), 
    _p2(0.f, 0.f)
{
}


Line2D::Line2D(const Line2D &obj) : 
    _p1(obj._p1), 
    _p2(obj._p2)
{
}


Line2D::Line2D(const Pnt2f &p0, const Pnt2f &p1)
{
    setPoints(p0, p1);
}


/*--------------------------- destructor ----------------------------------*/

Line2D::~Line2D(void)
{
}

/*---------------------------------------------------------------------------*/
/* Operators                                                                 */

Line2D &
Line2D::operator =(const Line2D &source)
{
    if(this == &source)
        return *this;
    
    _p1 = source._p1;
    _p2 = source._p2;
    
    return *this;
}

/*------------------------------ feature ----------------------------------*/

void Line2D::setPoints(const Pnt2f &p1, const Pnt2f &p2)
{
    _p1 = p1;
    _p2 = p2;
}

OSG_BEGIN_NAMESPACE

OSG_BASE_DLLMAPPING bool
operator ==(const Line2D &lhs, const Line2D &rhs)
{
    return (lhs._p1 == rhs._p1) && (lhs._p2 == rhs._p2);
}

OSG_BASE_DLLMAPPING
std::ostream &operator <<(std::ostream &outStream, const Line2D &obj)
{
    return outStream << obj.getP1() << ":" << obj.getP2();
}

OSG_END_NAMESPACE
