/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGLINE2D_H_
#define _OSGLINE2D_H_

#include <OSGBaseTypes.h>
#include <OSGVector.h>

OSG_BEGIN_NAMESPACE


/*! \ingroup GrpBaseBase
 */

class OSG_BASE_DLLMAPPING Line2D
{
    /*==========================  PUBLIC  =================================*/

  public:
      
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    Line2D(       void                        );
    Line2D(const  Line2D  &obj                );
    Line2D(const  Pnt2f &p1,  const Pnt2f &p2 );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructor                                 */
    /*! \{                                                                 */

    ~Line2D(void);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Operators                                 */
    /*! \{                                                                 */
    
    friend OSG_BASE_DLLMAPPING
    bool  operator ==(const Line2D &lhs, const Line2D &rhs);
    
    Line2D &operator = (const Line2D &source              );
    
    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Set                                       */
    /*! \{                                                                 */

    void setPoints(const Pnt2f &p1 , const Pnt2f &p2 );

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                    Get                                       */
    /*! \{                                                                 */

    const Pnt2f &getP1(void) const; 
    const Pnt2f &getP2(void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/

  protected:

    /*==========================  PRIVATE  ================================*/

  private:

    Pnt2f   _p1;
    Pnt2f   _p2;

};

OSG_BASE_DLLMAPPING
bool 
operator ==(const Line2D &lhs, const Line2D &rhs);

inline
bool
operator !=(const Line2D &lhs, const Line2D &rhs);

OSG_BASE_DLLMAPPING
std::ostream &operator <<(std::ostream &os,
    const Line2D        &obj);

OSG_END_NAMESPACE

#include <OSGLine2D.inl>

#endif // _OSGLINE_H_
