/*!
 * \class Pool
 * \brief handles pool of objects.
 * \author Andreas Zieringer PI-VR GmbH
 */

#ifndef _OSGPOOL_H_
#define _OSGPOOL_H_

#include <queue>

OSG_BEGIN_NAMESPACE

template<typename T>
class OSG_BASE_DLLMAPPING Pool
{
public:

    explicit Pool(void) :
        _avail_objs()
    {
    }

    ~Pool()
    {
        clear();
    }

    T* alloc(void)
    {
        if(!_avail_objs.empty())
        {
            T* obj = _avail_objs.front();
            _avail_objs.pop();
            return obj;
        }

        T* obj = new T;
        return obj;
    }

    void free(T* obj)
    {
        if(obj == NULL)
            return;

        _avail_objs.push(obj);
    }

    void clear(void)
    {
        while(!_avail_objs.empty())
        {
            T* obj = _avail_objs.front();
            _avail_objs.pop();
            delete obj;
        }
    }

private:

    std::queue<T *> _avail_objs;
};

OSG_END_NAMESPACE

#endif // _OSGPOOL_H_
