/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include "OSGConfig.h"
#include <OSGFormat.h>
#include <OSGMatrix.h>
#include <OSGVector.h>
#include <OSGColor.h>

#include "OSGStringHelper.h"

OSG_BEGIN_NAMESPACE

// UInt8
std::string toString(const unsigned char &val)
{
    return fmt::FormatInt(val).str();
}

// Int8
std::string toString(const char &val)
{
    return fmt::FormatInt(val).str();
}

// UInt16
std::string toString(const unsigned short &val)
{
    return fmt::FormatInt(val).str();
}

// Int16
std::string toString(const short &val)
{
    return fmt::FormatInt(val).str();
}

// UInt32
std::string toString(const unsigned int &val)
{
    return fmt::FormatInt(val).str();
}

// Int32
std::string toString(const int &val)
{
    return fmt::FormatInt(val).str();
}

// UInt64
std::string toString(const unsigned long long &val)
{
    return fmt::FormatInt(val).str();
}

// Int64
std::string toString(const long long &val)
{
    return fmt::FormatInt(val).str();
}

// UInt128
std::string toString(const unsigned __int128 &val)
{
    std::string str;
#if 0
    // doesn't link because clang doesn't support division with 128 bit integers!
    unsigned __int128 num = val;
    do
    {
        int digit = num % 10;
        str = std::to_string(digit) + str;
        num = (num - digit) / 10;
    }
    while (num != 0);
#endif
    return str;
}

// Int128
std::string toString(const __int128 &val)
{
    std::string str;
#if 0
    const bool negative = (val < 0);
    __int128 num = val;
    if(negative)
        num *= -1;
    do
    {
        int digit = num % 10;
        str = std::to_string(digit) + str;
        num = (num - digit) / 10;
    }
    while (num != 0);
    if(negative)
        str.insert(0, "-");
#endif
    return str;
}

// Real16
std::string toString(const Real16 &val)
{
    fmt::Writer w;
    w << float(val);
    return w.str();
}

// Real32
std::string toString(const float &val)
{
    fmt::Writer w;
    w << val;
    return w.str();
}

// Real64
std::string toString(const double &val)
{
    fmt::Writer w;
    w << val;
    return w.str();
}

// Real128
std::string toString(const long double &val)
{
    fmt::Writer w;
    w << val;
    return w.str();
}

std::string toString(const TransformationMatrix<Real32> &val)
{
    fmt::Writer w;
    const Real32 *v = val.getValues();

    w << "(" << val[0][0] << " " << val[1][0] << " " << val[2][0] << " " << val[3][0] << " "
             << val[0][1] << " " << val[1][1] << " " << val[2][1] << " " << val[3][1] << " "
             << val[0][2] << " " << val[1][2] << " " << val[2][2] << " " << val[3][2] << " "
             << val[0][3] << " " << val[1][3] << " " << val[2][3] << " " << val[3][3] << ")";
    return w.str();
}

std::string toString(const Point<float, 2> &val)
{
    fmt::Writer w;
    w << "(" << val[0] << " " << val[1] << ")";
    return w.str();
}

std::string toString(const Point<float, 3> &val)
{
    fmt::Writer w;
    w << "(" << val[0] << " " << val[1] << " " << val[2] << ")";
    return w.str();
}

std::string toString(const Point<float, 4> &val)
 {
    fmt::Writer w;
    w << "(" << val[0] << " " << val[1] << " " << val[2] << " " << val[3] << ")";
    return w.str();
}

std::string toString(const Vector<float, 2> &val)
{
    fmt::Writer w;
    w << "(" << val[0] << " " << val[1] << ")";
    return w.str();
}

std::string toString(const Vector<float, 3> &val)
{
    fmt::Writer w;
    w << "(" << val[0] << " " << val[1] << " " << val[2] << ")";
    return w.str();
}

std::string toString(const Vector<float, 4> &val)
{
    fmt::Writer w;
    w << "(" << val[0] << " " << val[1] << " " << val[2] << " " << val[3] << ")";
    return w.str();
}

std::string toString(const Color3<float> &val)
{
    fmt::Writer w;
    w << "(" << val[0] << " " << val[1] << " " << val[2] << ")";
    return w.str();
}

 std::string toString(const Color4<float> &val)
 {
    fmt::Writer w;
    w << "(" << val[0] << " " << val[1] << " " << val[2] << " " << val[3] << ")";
    return w.str();
}

OSG_END_NAMESPACE
