/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/


#ifndef _OSGSTRINGHELPER_H_
#define _OSGSTRINGHELPER_H_
#pragma once

#include <charconv>
#include <string>

#include <OSGConfig.h>
#include <OSGBase.h>
#include <OSGReal16.h>


OSG_BEGIN_NAMESPACE

// forward declare some type using e.g. Vec2f leads to compile errors.

template<class ValueTypeT>
class TransformationMatrix;

template<class ValueTypeT, UInt32 SizeI>
class Point;

template<class ValueTypeT, UInt32 SizeI>
class Vector;

template <class ValueTypeT>
class Color3;

template <class ValueTypeT>
class Color4;

/*---------------------------------------------------------------------*/
/*                Value to String Functions                            */

OSG_BASE_DLLMAPPING std::string toString(const unsigned char &val);
OSG_BASE_DLLMAPPING std::string toString(const char &val);
OSG_BASE_DLLMAPPING std::string toString(const unsigned short &val);
OSG_BASE_DLLMAPPING std::string toString(const short &val);
OSG_BASE_DLLMAPPING std::string toString(const unsigned int &val);
OSG_BASE_DLLMAPPING std::string toString(const int &val);
OSG_BASE_DLLMAPPING std::string toString(const unsigned long long &val);
OSG_BASE_DLLMAPPING std::string toString(const long long &val);
OSG_BASE_DLLMAPPING std::string toString(const unsigned __int128 &val);
OSG_BASE_DLLMAPPING std::string toString(const __int128 &val);
OSG_BASE_DLLMAPPING std::string toString(const Real16 &val);
OSG_BASE_DLLMAPPING std::string toString(const float &val);
OSG_BASE_DLLMAPPING std::string toString(const double &val);
OSG_BASE_DLLMAPPING std::string toString(const long double &val);

OSG_BASE_DLLMAPPING std::string toString(const TransformationMatrix<Real32> &val);

OSG_BASE_DLLMAPPING std::string toString(const Point<float, 2> &val);
OSG_BASE_DLLMAPPING std::string toString(const Point<float, 3> &val);
OSG_BASE_DLLMAPPING std::string toString(const Point<float, 4> &val);

OSG_BASE_DLLMAPPING std::string toString(const Vector<float, 2> &val);
OSG_BASE_DLLMAPPING std::string toString(const Vector<float, 3> &val);
OSG_BASE_DLLMAPPING std::string toString(const Vector<float, 4> &val);

OSG_BASE_DLLMAPPING std::string toString(const Color3<float> &val);
OSG_BASE_DLLMAPPING std::string toString(const Color4<float> &val);

template <typename T>
T fromHexString(const std::string &hex)
{
    T r(0);
    if(!hex.empty())
    {
        const int len = static_cast<int>(hex.length() - 1);
        for(int i = len; i >= 0; --i)
        {
            UInt8 b;
            std::from_chars(hex.data() + i, hex.data() + i + 1, b, 16);
            r |= static_cast<T>(b) << ((len - i) << 2);
        }
    }
    return r;
}

template <typename T>
std::string toHexString(T w)
{
    const size_t hex_len = (sizeof(T) << 1);
    static const char *digits = "0123456789ABCDEF";
    std::string rc(hex_len, '0');
    for (size_t i=0, j=(hex_len-1)*4 ; i<hex_len; ++i,j-=4)
        rc[i] = digits[(w>>j) & 0x0f];
    return rc;
}

OSG_END_NAMESPACE


#endif /* _OSGSTRINGHELPER_H_ */
