/*!
 * \class ThreadPool
 * \brief handles pool of threads.
 * \author Andreas Zieringer PI-VR GmbH
 */

#include "OSGBaseFunctions.h"
#include "OSGBaseThread.h"
#include "OSGThreadPool.h"

OSG_USING_NAMESPACE

ThreadPool::ThreadPool(void) :
    _thread(NULL)
{
    char thread_name[256];
    sprintf(thread_name, "ThreadPoolThread%p", this);
    _thread = BaseThread::get(thread_name);
}

ThreadPool::~ThreadPool()
{
    if(_thread != NULL)
    {
        BaseThread::join(_thread);
        _thread->subRef();
        _thread = NULL;
    }
}

void ThreadPool::run(taskfp fp, void *arg)
{
    _thread->runFunction(fp, arg);
}

void ThreadPool::wait(void)
{
    if(_thread != NULL)
        BaseThread::join(_thread);
}
