/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _STREAMSOCKET_H_
#define _STREAMSOCKET_H_
#pragma once

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <OSGBase.h>
#include <OSGSocketException.h>
#include <OSGSocketAddress.h>
#include <OSGSocket.h>

OSG_BEGIN_NAMESPACE

class OSG_BASE_DLLMAPPING StreamSocket:public Socket
{
    /*==========================  PUBLIC  =================================*/
  public:

    static const char *getClassname(void) { return "CLASSNAME"; }
 
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    StreamSocket(void);
    StreamSocket(const StreamSocket &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Socket functionaliy                        */
    /*! \{                                                                 */

    virtual void         open      (void                  );
    virtual void         close     (void                  );
            StreamSocket acceptFrom(SocketAddress &address);
            StreamSocket accept    (void                  );
            void         setDelay  (bool           value  );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Assignment                                 */
    /*! \{                                                                 */

    const StreamSocket & operator =(const StreamSocket &source);

    static void setSDP(bool s);
    static bool getSDP(void);

    /*! \}                                                                 */

    /*=========================  PROTECTED  ===============================*/
  protected:

    /*==========================  PRIVATE  ================================*/
  private:

    typedef Socket Inherited;

    static bool _sdp;
};

OSG_END_NAMESPACE

#define OSG_STREAMSOCKET_HEADER_CVSID "@(#)$Id: $"

#endif
