/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGRENDERACTION_H_
#define _OSGRENDERACTION_H_
#pragma once

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <vector>
#include <stack>
#include <map>
#include <set>

#include <OSGSystemDef.h>
#include <OSGBaseTypes.h>
#include <OSGRenderActionBase.h>
#include <OSGMatrix.h>
#include <OSGMaterial.h>
#include <OSGStatElemTypes.h>

OSG_BEGIN_NAMESPACE

//---------------------------------------------------------------------------
//  Forward References
//---------------------------------------------------------------------------

class Material;

class Geometry;
class State;
class Light;
class LightEnv;
class LightChunk;
class ClipPlane;
class SClipPlaneChunk;


//---------------------------------------------------------------------------
//   Types
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//  Class
//---------------------------------------------------------------------------

/*! \brief RenderAction class
 */

class OSG_SYSTEMLIB_DLLMAPPING RenderAction : public RenderActionBase
{
  public:

    //-----------------------------------------------------------------------
    //   constants                                                               
    //-----------------------------------------------------------------------

    static StatElemDesc<StatTimeElem>       statDrawTime;
    static StatElemDesc<StatUInt64Elem>     statNMaterials;
    static StatElemDesc<StatUInt64Elem>     statNMatrices;
    static StatElemDesc<StatUInt64Elem>     statNLights;
    static StatElemDesc<StatUInt64Elem>     statNGeometries;
    static StatElemDesc<StatUInt64Elem>     statNTransGeometries;
    static StatElemDesc<StatIntOnceElem>    statNTextures;
    static StatElemDesc<StatIntOnceElem>    statNTexBytes;
    static StatElemDesc<StatStringElem>     statNOcclusionMode;
    static StatElemDesc<StatUInt64Elem>     statNOcclusionTests;
    static StatElemDesc<StatUInt64Elem>     statNOcclusionCulled;

    static const Int32 OcclusionCullingAccurate;
    static const Int32 OcclusionCullingFast;


    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------
  
    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    static RenderAction *create      (void                    );
    
    static void          setPrototype(RenderAction *pPrototype);
    static RenderAction *getPrototype(void                    );


    static void registerEnterDefault (const FieldContainerType &type, 
                                      const Action::Functor    &func);
    
    static void registerLeaveDefault (const FieldContainerType &type, 
                                      const Action::Functor    &func);

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    virtual ~RenderAction(void); 



    /*------------------------- your_operators ------------------------------*/


    inline const Matrix top_matrix (      void          );



    void setStateSorting(bool s);
    bool getStateSorting(void);


    inline State *getCurrentState(void);

    /*------------------------- comparison ----------------------------------*/

    void setSortTrans(bool bVal);
    bool getSortTrans(void) const;

    void setZWriteTrans(bool bVal);
    bool getZWriteTrans(void) const;

    void setLocalLights(bool bVal);
    bool getLocalLights(void) const;

    void setOcclusionCulling(bool bVal);
    bool getOcclusionCulling(void) const;

    virtual void setUseMulticastSLI(bool on);
    virtual bool getUseMulticastSLI() const;

    virtual void setOcclusionCullingMode(Int32 mode);
    virtual Int32 getOcclusionCullingMode(void) const;

    void setOcclusionCullingThreshold(UInt32 threshold);
    UInt32 getOcclusionCullingThreshold(void) const;

    void setUseGLFinish(bool s);
    bool getUseGLFinish(void) const;

    void setDepthOnlyPass(bool s);
    bool getDepthOnlyPass(void) const;

    virtual void setPreselectionMode(UInt32 mode);
    virtual void setSelectionMode(UInt32 m);
    UInt32 getSelectionMode(void) const;

    void setPolygonMode(const OSGGLenum& m);
    const OSGGLenum getPolygonMode(void) const;

    void setHdrReferenceWhite(const float nits);
    float getHdrReferenceWhite() const;

    /*------------------------- comparison ----------------------------------*/

    void deleteOcclusionQueriesPool(void);
    OSGGLuint getOcclusionQuery(void);
    OSGGLuint getOcclusionQuery(NodePtr node);
    void setOcclusionQuery(NodePtr node, OSGGLuint occlusionQuery);
    void resetOcclusionQueryIndex(void);
    void setOcclusionMask(NodePtr node, UInt8 mask);
    bool hasGeometryChild(NodePtr node);

    // test a single node
    bool            isVisible( Node* node );
    

    void (OSG_APIENTRY* _glGenQueriesARB)(OSGGLsizei, OSGGLuint*);
    void (OSG_APIENTRY* _glDeleteQueriesARB)(OSGGLsizei, OSGGLuint*);
    void (OSG_APIENTRY* _glBeginQueryARB)(OSGGLenum, OSGGLuint);
    void (OSG_APIENTRY* _glEndQueryARB)(OSGGLenum);
    void (OSG_APIENTRY* _glGetQueryObjectuivARB)(OSGGLuint, OSGGLenum, OSGGLuint*);

  protected:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    typedef RenderActionBase Inherited;

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    static RenderAction    *_pPrototype;

    static std::vector<Functor> *_vDefaultEnterFunctors;
    static std::vector<Functor> *_vDefaultLeaveFunctors;

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------
    Matrix                    _currMatrix;

    State                    *_pActiveState;

    UInt32                    _uiNumMaterialChanges;
    UInt32                    _uiNumMatrixChanges;
    UInt32                    _uiNumLightChanges;
    UInt32                    _uiNumGeometries;
    UInt32                    _uiNumTransGeometries;
    UInt32                    _uiNumOcclusionTests;
    UInt32                    _uiNumOcclusionCulled;

    bool                      _bSortTrans;
    bool                      _bZWriteTrans;
    bool                      _bLocalLights;
    bool                      _bOcclusionCulling;
    Int32                     _occlusionCullingMode;
    UInt32                    _occlusionCullingThreshold;
    UInt32                    _currentOcclusionQueryIndex;
    std::vector<NodePtr>      _occluded_nodes;
    std::set<UInt32>          _hier_occlusions;
    UInt32                    _occ_bb_dl;



    bool                      _useGLFinish;

    bool                      _depth_only_pass;
    UInt32                    _selection_mode;
    OSGGLenum                 _polygon_mode;

    float                     _hdrReferenceWhite;


    UInt32                      _clipPlanesState;
    std::vector<std::vector<UInt32> > _clipPlanesTable;
    std::vector<UInt32>               _clipPlanesPath;

    bool                      _stateSorting;

    OSGGLuint _occlusionQuery;
    std::vector<OSGGLuint> _occlusionQueriesPool;
    std::map<UInt32, OSGGLuint> _occlusionQueries;

//    Time                 _tMatSlot

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    // prohibit default functions (move to 'public' if you need one)

    RenderAction(void);
    RenderAction(const RenderAction &source);

    void operator =(const RenderAction &source);

    // access default functors

    virtual std::vector<Functor> *getDefaultEnterFunctors(void);
    virtual std::vector<Functor> *getDefaultLeaveFunctors(void);

    void getMaterialStates(Material *mat, std::vector<State *> &states);


  private:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend classes                                                      
    //-----------------------------------------------------------------------

    friend class ShadowViewport;

    //-----------------------------------------------------------------------
    //   friend functions                                                    
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    static char cvsid[];
    
    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------
    
    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------

OSG_END_NAMESPACE

#include "OSGRenderAction.inl"

#endif /* _OSGRENDERACTION_H_ */


