/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>

#include "OSGConfig.h"

#include "OSGRemoteAspect.h"

OSG_USING_NAMESPACE

/** \class osg::RemoteAspect
 *  \ingroup GrpSystemCluster
 *  \brief Remote aspect controll class
 *
 * The RemoteAspecet is used to synchronize changes of FieldContainers
 * with remote hosts. All changes stored in the current change list
 * are send to a Connection.
 *
 * It is possible to send changes in both directions.
 *
 **/

RemoteAspect::FieldFilterT  RemoteAspect::_fieldFilter;

/*-------------------------------------------------------------------------*/
/*                            constructor destructor                       */

/*! add a new field filter. The given fieldmaks will not be transfered
 */
void RemoteAspect::addFieldFilter( UInt32 typeId,BitVector mask)
{
    _fieldFilter[typeId] |= mask;
}

/*! remove the filter for the given type and mask
 */
void RemoteAspect::subFieldFilter( UInt32 typeId,BitVector mask)
{
    _fieldFilter[typeId] &= ~mask;
}

RemoteAspect::FieldFilterT const &
RemoteAspect::getFieldFilter(void)
{
    return _fieldFilter;
}

BitVector
RemoteAspect::getFieldFilter(UInt32 typeId)
{
    FieldFilterT::const_iterator fI = _fieldFilter.find(typeId);

    if(fI != _fieldFilter.end())
    {
        return fI->second;
    }
    else
    {
        return TypeTraits<BitVector>::BitsClear;
    }
}

void RemoteAspect::createCurrentStateChangeList(const FieldContainerPtr &start, ChangeList *cl)
{
    if(cl == NULL)
        return;

    cl->clearAll();

    UInt32 startId = start.getFieldContainerId();

    // ok we have to iterate over all fc's bcause a hash map has a random order!
    FieldContainerFactory::FieldContainerStoreConstIt fcIter = FieldContainerFactory::the()->getFieldContainerStore()->begin();
    FieldContainerFactory::FieldContainerStoreConstIt fcEnd = FieldContainerFactory::the()->getFieldContainerStore()->end();

    while(fcIter != fcEnd)
    {
#ifdef OSG_USE_FC_MAP
        FieldContainerPtr fc = fcIter->second;
#else
        FieldContainerPtr fc = *fcIter;
#endif
        if(fc != NullFC && fc.getFieldContainerId() >= startId)
        {
            cl->addCreated(getContainerId(fc));
            for(UInt32 i=0;i<fc.getRefCount();++i)
                cl->addAddRefd(fc);
            cl->addChanged(fc, FieldBits::AllFields);
        }
        ++fcIter;
    }
}
