/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _REMOTEASPECT_H_
#define _REMOTEASPECT_H_
#pragma once

#include <map>

#include <OSGSystemDef.h>
#include <OSGBaseTypes.h>
#include <OSGFieldContainerPtr.h>
#include <OSGChangeList.h>

OSG_BEGIN_NAMESPACE

class OSG_SYSTEMLIB_DLLMAPPING RemoteAspect
{ 
    /*==========================  PUBLIC  =================================*/
  public:

    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    typedef std::map<UInt32,osg::AlignedBitVector> FieldFilterT;

    static void addFieldFilter   ( UInt32 typeId,BitVector mask   );
    static void subFieldFilter   ( UInt32 typeId,BitVector mask   );
    
    static FieldFilterT const &getFieldFilter(void         );
    static BitVector           getFieldFilter(UInt32 typeId);

    static void createCurrentStateChangeList(const FieldContainerPtr &start,
                                             ChangeList *cl);

    /** fild filter **/
    static FieldFilterT               _fieldFilter;

private:

    RemoteAspect(UInt32 aspectId=0);
    virtual ~RemoteAspect(void);

	// prohibit default functions (move to 'public' if you need one)
    RemoteAspect(const RemoteAspect &source);
    RemoteAspect &operator =(const RemoteAspect &source);
};

OSG_END_NAMESPACE

#define OSGREMOTEASPECT_HEADER_CVSID "@(#)$Id:$"

#endif /* _REMOTEASPECT_H_ */
