/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *           Copyright (C) 2000-2002,2002 by the OpenSG Forum                *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#include "OSGConfig.h"
#include "OSGLock.h"
#include "OSGFieldContainerPtr.h"
#include "OSGFieldContainerType.h"

#include "OSGFieldContainerFactoryImpl.h"

//#define OSG_DEBUG_FCF

OSG_USING_NAMESPACE

/*-------------------------------------------------------------------------*/
/*                              Register                                   */

UInt32 FieldContainerFactory::registerFieldContainer(const FieldContainerPtr &pFieldContainer)
{
    UInt32 returnValue = 0;

    if(_pStoreLock != NULL)
        _pStoreLock->aquire();

    if(_pFieldContainerStore == NULL)
    {
        _pFieldContainerStore = new FieldContainerStore;

#ifdef OSG_USE_FC_MAP
        _pFieldContainerStore->insert(std::make_pair(_nextContainerId++, NullFC));
#else
        _pFieldContainerStore->push_back(NullFC);
#endif
    }

#ifdef OSG_USE_FC_MAP
    // ok the id will be set after calling registerFieldContainer()
    // and here we store a copy of the pointer so we need to set the id here also!
#ifdef OSG_INVALID_PTR_CHECK
    pFieldContainer._id = _nextContainerId;
#endif
     _pFieldContainerStore->insert(std::make_pair(_nextContainerId++, pFieldContainer));
     returnValue = _nextContainerId - 1;
#else
    // ok the id will be set after calling registerFieldContainer()
    // and here we store a copy of the pointer so we need to set the id here also!
#ifdef OSG_INVALID_PTR_CHECK
    pFieldContainer._id = _pFieldContainerStore->size();
#endif
    _pFieldContainerStore->push_back(pFieldContainer);
    returnValue = _pFieldContainerStore->size() - 1;
#endif

    if(_pStoreLock != NULL)
        _pStoreLock->release();

    return returnValue;
}

void FieldContainerFactory::registeredFieldContainer(const FieldContainerPtr  &pFieldContainer)
{
#ifdef OSG_DEBUG_FCF
    if( pFieldContainer != NullFC)
    {
        printf("registerFieldContainer\n");
        printf("\tid %u\n", pFieldContainer.getFieldContainerId());
        printf("\ttype '%s'\n", pFieldContainer->getType().getCName());
    }
    else
    {
        printf("registerFieldContainer: NullFC!\n");
    }
#endif
}

bool FieldContainerFactory::unregisterFieldContainer(UInt32 fieldContainerId)
{
    if(fieldContainerId == 0)
        return false;

    if(_pStoreLock != NULL)
        _pStoreLock->aquire();

    if(_pFieldContainerStore != NULL)
    {
#ifdef OSG_DEBUG_FCF
        printf("unregisterFieldContainer\n");
        printf("\tid %u\n", fieldContainerId);
#endif
#ifdef OSG_USE_FC_MAP
        _pFieldContainerStore->erase(fieldContainerId);
#else
        (*_pFieldContainerStore)[fieldContainerId] = NullFC;
#endif
    }

    if(_pStoreLock != NULL)
        _pStoreLock->release();

    return false;
}

