/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *           Copyright (C) 2000-2002,2002 by the OpenSG Forum                *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGFIELDCONTAINERFACTORYIMPL_INL_
#define _OSGFIELDCONTAINERFACTORYIMPL_INL_

#ifdef OSG_DOC_FILES_IN_MODULE
/*! \file OSGFieldContainerFactoryImpl.inl
    \ingroup GrpSystemFieldContainer
 */
#endif

OSG_BEGIN_NAMESPACE

/*-------------------------------------------------------------------------*/
/*                              Mapper                                     */

inline
void FieldContainerFactory::setMapper(FieldContainerMapper *pMapper)
{
    _pMapper = pMapper;
}

/*-------------------------------------------------------------------------*/
/*                                Get                                      */

#ifdef WIN32
__forceinline
#else
inline
#endif
FieldContainerPtr FieldContainerFactory::getContainer(
    UInt32 uiContainerId) const
{
    FieldContainerPtr returnValue = NullFC;

#ifdef OSG_USE_FC_MAP
    // removed the _pStoreLock the hash map should be thread safe!
    // gived a huge speed improvement with enabled invalid pointer check!
    _pStoreLock->aquire();
    FieldContainerStore::const_iterator it = _pFieldContainerStore->find(uiContainerId);
    if(it != _pFieldContainerStore->end())
        returnValue = it->second;
    else
        returnValue = NullFC;
    _pStoreLock->release();
#else
#ifdef OSG_USE_CONCURRENT_VECTOR
    if (uiContainerId < _pFieldContainerStore->size())
        returnValue = (*_pFieldContainerStore)[uiContainerId];
#else
    _pStoreLock->aquire();
    if(uiContainerId < _pFieldContainerStore->size())
    {
        returnValue = (*_pFieldContainerStore)[uiContainerId];
    }
    _pStoreLock->release();
#endif
#endif

    return returnValue;
}


inline
FieldContainerPtr FieldContainerFactory::getMappedContainer(
    UInt32 uiContainerId) const
{
    if(_pMapper != NULL)
    {
        return getContainer(_pMapper->map(uiContainerId));
    }
    else
    {
        return getContainer(uiContainerId);
    }
}

/*-------------------------------------------------------------------------*/
/*                            Invalid Pointer                              */

inline
void FieldContainerFactory::setThrowInvalidPointerException(bool s)
{
#ifndef OSG_INVALID_PTR_CHECK
    FFATAL(("FieldContainerFactory::setThrowInvalidPointerException: invalid pointer check is not enabled, use the 'invalid_pointer_check' option in the scons build system!\n"));
#else
    _throw_invalid_pointer_exception = s;
#endif
}

inline
bool FieldContainerFactory::getThrowInvalidPointerException(void) const
{
    return _throw_invalid_pointer_exception;
}

inline
void FieldContainerFactory::checkThrowInvalidPointerException(void) const
{
    if(!_throw_invalid_pointer_exception)
        return;

#ifdef _MSC_VER
    __debugbreak();  // Triggers debugger break on Windows
#endif

    throw InvalidPointerException();
}

inline
void FieldContainerFactory::shrinkToFit(void)
{
#ifdef OSG_USE_FC_MAP
    FieldContainerStore tmp(*_pFieldContainerStore);
    _pFieldContainerStore->swap(tmp);
#endif
}

OSG_END_NAMESPACE

#define OSGFIELDCONTAINERFACTORY_INLINE_CVSID "@(#)$Id: $"

#endif /* _OSGFIELDCONTAINERFACTORYIMPL_INL_ */
