/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *           Copyright (C) 2000-2002,2002 by the OpenSG Forum                *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGFIELDCONTAINERPTRDEPIMPL_INL_
#define _OSGFIELDCONTAINERPTRDEPIMPL_INL_

#ifdef OSG_DOC_FILES_IN_MODULE
/*! \file OSGFieldContainerPtrDepImpl.inl
    \ingroup GrpSystemFieldContainer
 */
#endif

OSG_BEGIN_NAMESPACE

template <class BasePtrTypeT, class FieldContainerTypeT> inline
std::ostream &operator <<(
          std::ostream                             &os,
    const FCPtr<BasePtrTypeT, FieldContainerTypeT> &fc)
{
    if(fc == NullFC)
    {
        os << std::hex << "FCPtr 0x" << &fc << std::dec << ":NullFC";
    }
    else
    {
        os << std::hex
           << "FCPtr 0x"
           << &fc
           << std::dec
           << ":"
           << fc->getType().getName()
           << "Ptr(0x"
           << std::hex
           << (&(*fc))
           << std::dec
           << ")";
    }

    return os;
}

inline
void FieldContainerPtrBase::deleteContainers(void) const
{
//    dump(0, FCDumpFlags::RefCount);

    UInt32 id = 0;
#ifndef OSG_INVALID_PTR_CHECK
    if (_storeP != nullptr)
        id = _storeP->_id;
    ChangeList* cl = Thread::getCurrentChangeList();
    if (cl != nullptr)
        cl->addDestroyed(id);
#else
    id = _id;
    ChangeList* cl = Thread::getCurrentChangeList();
    if (cl != nullptr)
        cl->addDestroyed(id);
#endif

    if (_storeP != nullptr)
    {
        _storeP->onDestroy();

#if defined(OSG_GV_BETA) && defined(OSG_DBG_MEM)
        fprintf(stderr, "GV_MEM_FC_DBG : (%u) d (%p|%u)\n",
                Thread::getAspect(),
                _storeP,
                _storeP->getType().getId());
#endif

#if defined(OSG_FIXED_MFIELDSYNC)
        _storeP->~FieldContainer();
#endif

        delete _storeP;

        // Clean up a little.
        const_cast<FieldContainerPtrBase*>(this)->_storeP = nullptr;
#ifdef OSG_INVALID_PTR_CHECK
        const_cast<FieldContainerPtrBase*>(this)->_id = 0;
#endif
    }

    FieldContainerFactory::the()->unregisterFieldContainer(id);
}

inline
void FieldContainerPtrBase::subRef(void) const
{
#ifdef OSG_INVALID_PTR_CHECK
    if(FieldContainerFactory::the()->getContainer(_id) == NullFC)
    {
        FFATAL(("FieldContainerPtr::subRef: invalid pointer!\n"));
        FieldContainerFactory::the()->checkThrowInvalidPointerException();
        return;
    }
#endif

    if(_storeP == nullptr)
        return;

#if !defined(OSG_FIXED_MFIELDSYNC)
    Int32 oldRefCount = (_storeP->_refCount).fetch_sub(1);
    if(oldRefCount <= 1) // we know we just decremented so if the old value was 1 it is now 0.
    {
		if(oldRefCount == 0) // if the value is 0, we did not made an addRef before and can immediately delete it.
		{ 
			deleteContainers();
		}
		else if(oldRefCount == 1)
		{
			subRef(); // do a subref to get a refCount of 0 in the next call
		}
    }
    else
    {
        ChangeList* cl = Thread::getCurrentChangeList();
        if (cl != nullptr)
            cl->addSubRefd(*(static_cast<const FieldContainerPtr *>(this)));
    }
#else
    ChangeList* cl = Thread::getCurrentChangeList();
    if (cl != nullptr)
        cl->addSubRefd(*(static_cast<const FieldContainerPtr *>(this)));
#endif
}

#if defined(OSG_FIXED_MFIELDSYNC)
inline
void FieldContainerPtrBase::doSubRef(void) const
{
    if(_storeP == nullptr)
        return;
    
    Int32 oldRefCount = (_storeP->_refCount).fetch_sub(1);
    if( oldRefCount <= 1)
    {
		if (oldRefCount == 0) // if the value is 0, we did not made an addRef before and can immediately delete it.
		{
			deleteContainers();
		}
		else if(oldRefCount == 1)
		{
			doSubRef(); // do a subref to get a refCount of 0 in the next call
		}
    }
}
#endif

OSG_END_NAMESPACE

#define OSGFIELDCONTAINERPTRDEPIMPL_INLINE_CVSID "@(#)$Id: $"

#endif /* _OSGFIELDCONTAINERPTRDEPIMPL_INL_ */
