/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *           Copyright (C) 2000-2002,2002 by the OpenSG Forum                *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGNODEPTRDEPIMPL_INL_
#define _OSGNODEPTRDEPIMPL_INL_

#ifdef OSG_DOC_FILES_IN_MODULE
/*! \file OSGNodePtrDepImpl.inl
    \ingroup GrpSystemFieldContainer
 */
#endif

#ifdef WIN32

#ifndef FORCEINLINE
#define FORCEINLINE __forceinline
#endif

#else

#ifdef __GNUC__

#ifndef FORCEINLINE
#define FORCEINLINE __inline__
#endif

#else

#ifndef FORCEINLINE
#define FORCEINLINE inline
#endif

#endif
#endif

OSG_BEGIN_NAMESPACE

/*-------------------------------------------------------------------------*/
/*                            Constructors                                 */

FORCEINLINE
NodePtr::NodePtr(const CNodePtr &source) :
    Inherited(source)
{
}

FORCEINLINE
NodePtr::NodePtr(const Node *source) :
    Inherited(source)
{
}

FORCEINLINE
NodePtr::NodePtr(const Node   *source,
                 const UInt16  uiSize,
                 const UInt16  uiParentPos) :

    Inherited(source, uiSize, uiParentPos)
{
}

template <class InTypeT> FORCEINLINE
NodePtr NodePtr::dcast(const InTypeT oIn)
{
    // improved speed!
    if(oIn != NullFC && oIn->getType().isDerivedFrom(NodePtr::StoredObjectType::getClassType()))
        return NodePtr((static_cast<const Node *>(&*oIn)), oIn.getContainerSize(), oIn.getParentFieldPos());
    return NullFC;

    /*
    return NodePtr(
        (dynamic_cast<const Node *>(&*oIn)),
        oIn.getContainerSize(),
        oIn.getParentFieldPos());
    */
}

FORCEINLINE
void NodePtr::operator = (const CNodePtr &source)
{
    // copy parts inherited from parent
    *(static_cast<Inherited *>(this)) = source;
}

/*-------------------------------------------------------------------------*/
/*                              Pointer                                    */

FORCEINLINE
NodePtr::NodePtr(const Node &source) :
    Inherited(source)
{
}

FORCEINLINE
NodePtr Node::getPtr(void) const
{
    return NodePtr(*this);
}

FORCEINLINE
NodeCorePtr Node::getCore(void)
{
    return _sfCore.getValue();
}

FORCEINLINE
NodeCorePtr Node::getCore(void) const
{
    return _sfCore.getValue();
}

/*-------------------------------------------------------------------------*/
/*                                Core                                     */

#ifndef OSG_2_PREP
FORCEINLINE
NodeCore *NodePtr::getCore(void)
{
    return (reinterpret_cast<Node *>(getCPtr()))->getCore().getCPtr();
}

FORCEINLINE
NodeCore *NodePtr::getCore(void) const
{
    return (reinterpret_cast<Node *>(getCPtr()))->getCore().getCPtr();
}
#endif

FORCEINLINE
void Node::onCreate(const Node *source)
{
    if(source == NULL)
        return;

    setCore(source->getCore());

    AttachmentMap::const_iterator fcI =
        source->_attachmentMap.getValue().begin();
    AttachmentMap::const_iterator fcEnd =
        source->_attachmentMap.getValue().end();

    while(fcI != fcEnd)
    {
        addAttachment((*fcI).second);

        ++fcI;
    }
}

OSG_FIELD_CONTAINER_INL_DEF(Node, NodePtr)

FORCEINLINE
NodePtr Node::clone(void)
{
    return cloneTree(getPtr());
}

OSG_END_NAMESPACE

#define OSGNODEPTRDEP_INLINE_CVSID "@(#)$Id: $"

#endif /* _OSGNODEPTRIMPL_INL_ */
