#pragma once

#include <type_traits>

#include <OSGBaseTypes.h>
#include <OSGFieldContainerPtr.h>
#include <OSGSystemDef.h>
#include <OSGAttachment.h>
#include <OSGAttachmentContainer.h>
#include <OSGNodeCore.h>
#include <OSGGeoPropPositions.h>

OSG_BEGIN_NAMESPACE

//---------------------------------------------------------------------------
//   Dynamic and static cast functions
//---------------------------------------------------------------------------

template <typename... Ts>
using void_t = void;

template <typename T, typename = void>
struct has_typedef_ptr_type : std::false_type {};

template <typename T>
struct has_typedef_ptr_type<T, void_t<typename T::PtrType>> : std::true_type {};

template<typename Type>
auto dcast(const FieldContainerPtr& fc)
{
    if constexpr(std::is_same_v<Type, FieldContainer>)
    {
        if (fc != NullFC && fc->getType().isDerivedFrom(Type::getClassType()))
            return FieldContainerPtr(static_cast<Type*>(fc.getCPtr()));
        return FieldContainerPtr(NullFC);
    }
    else if constexpr(std::is_same_v<Type, Attachment>)
    {
        if (fc != NullFC && fc->getType().isDerivedFrom(Type::getClassType()))
            return AttachmentPtr(static_cast<Type*>(fc.getCPtr()));
        return AttachmentPtr(NullFC);
    }
    else if constexpr(std::is_same_v<Type, AttachmentContainer>)
    {
        if (fc != NullFC && fc->getType().isDerivedFrom(Type::getClassType()))
            return AttachmentContainerPtr(static_cast<Type*>(fc.getCPtr()));
        return AttachmentContainerPtr(NullFC);
    }
    else if constexpr(std::is_same_v<Type, NodeCore>)
    {
        if (fc != NullFC && fc->getType().isDerivedFrom(Type::getClassType()))
            return NodeCorePtr(static_cast<Type*>(fc.getCPtr()));
        return NodeCorePtr(NullFC);
    }
    else if constexpr(has_typedef_ptr_type<Type>::value) // e.g. GeoPositions3f has no Ptr typedef but a PtrType typedef
    {
        if (fc != NullFC && fc->getType().isDerivedFrom(Type::getClassType()))
            return typename Type::PtrType(static_cast<Type*>(fc.getCPtr()));
        return typename Type::PtrType(NullFC);
    }
    else
    {
        if (fc != NullFC && fc->getType().isDerivedFrom(Type::getClassType()))
            return typename Type::Ptr(static_cast<Type*>( fc.getCPtr()));
        return typename Type::Ptr(NullFC);
    }
}

template<typename Type>
auto dcast(const UInt32 id)
{
    return osg::dcast<Type>(FieldContainerFactory::the()->getContainer(id));
}

template<typename Type>
auto scast(const FieldContainerPtr& fc)
{
    if constexpr(std::is_same_v<Type, FieldContainer>)
    {
        if (fc != NullFC)
            return FieldContainerPtr(static_cast<Type*>(fc.getCPtr()));
        return FieldContainerPtr(NullFC);
    }
    else if constexpr(std::is_same_v<Type, Attachment>)
    {
        if (fc != NullFC)
            return AttachmentPtr(static_cast<Type*>(fc.getCPtr()));
        return AttachmentPtr(NullFC);
    }
    else if constexpr(std::is_same_v<Type, AttachmentContainer>)
    {
        if (fc != NullFC)
            return AttachmentContainerPtr(static_cast<Type*>(fc.getCPtr()));
        return AttachmentContainerPtr(NullFC);
    }
    else if constexpr(std::is_same_v<Type, NodeCore>)
    {
        if (fc != NullFC)
            return NodeCorePtr(static_cast<Type*>(fc.getCPtr()));
        return NodeCorePtr(NullFC);
    }
    else if constexpr(has_typedef_ptr_type<Type>::value) // e.g. GeoPositions3f has no Ptr typedef but a PtrType typedef
    {
        if (fc != NullFC)
            return typename Type::PtrType(static_cast<Type*>(fc.getCPtr()));
        return typename Type::PtrType(NullFC);
    }
    else
    {
        if (fc != NullFC)
            return typename Type::Ptr(static_cast<Type*>( fc.getCPtr()));
        return typename Type::Ptr(NullFC);
    }
}

template<typename Type>
auto scast(const UInt32 id)
{
    return osg::scast<Type>(FieldContainerFactory::the()->getContainer(id));
}

OSG_END_NAMESPACE
