/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *           Copyright (C) 2000-2002,2002 by the OpenSG Forum                *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGFIELDCONTAINERBASE_H_
#define _OSGFIELDCONTAINERBASE_H_
#pragma once

#ifdef OSG_DOC_FILES_IN_MODULE
/*! \file OSGFieldContainerBase.h
    \ingroup GrpSystemFieldContainer
 */
#endif

#include <OSGBaseTypes.h>
#include <OSGFieldContainerBase.h>

OSG_BEGIN_NAMESPACE

/*! \ingroup GrpSystemFieldContainer
 */

namespace FieldBits
{
    constexpr BitVector AllFields = TypeTraits<BitVector>::BitsSet;
    //constexpr BitVector AllFields = 0xffffffffffffffff;
    // we use the last possible Field for this, just set the last possible bit this is (1 << 127) for 128 but integer.
    constexpr BitVector AllFieldsCharged = (TypeTraits<BitVector>::One << ((sizeof(BitVector) << 3) - 1));

    constexpr BitVector NoField   = 0x00000000;


    constexpr BitVector Field0    = 0x00000001;
    constexpr BitVector Field1    = 0x00000002;
    constexpr BitVector Field2    = 0x00000004;
    constexpr BitVector Field3    = 0x00000008;

    constexpr BitVector Field4    = 0x00000010;
    constexpr BitVector Field5    = 0x00000020;
    constexpr BitVector Field6    = 0x00000040;
    constexpr BitVector Field7    = 0x00000080;

    constexpr BitVector Field8    = 0x00000100;
    constexpr BitVector Field9    = 0x00000200;
    constexpr BitVector Field10   = 0x00000400;
    constexpr BitVector Field11   = 0x00000800;

    constexpr BitVector Field12   = 0x00001000;
    constexpr BitVector Field13   = 0x00002000;
    constexpr BitVector Field14   = 0x00004000;
    constexpr BitVector Field15   = 0x00008000;

    constexpr BitVector Field16   = 0x00010000;
    constexpr BitVector Field17   = 0x00020000;
    constexpr BitVector Field18   = 0x00040000;
    constexpr BitVector Field19   = 0x00080000;

    constexpr BitVector Field20   = 0x00100000;
    constexpr BitVector Field21   = 0x00200000;
    constexpr BitVector Field22   = 0x00400000;
    constexpr BitVector Field23   = 0x00800000;

    constexpr BitVector Field24   = 0x01000000;
    constexpr BitVector Field25   = 0x02000000;
    constexpr BitVector Field26   = 0x04000000;
    constexpr BitVector Field27   = 0x08000000;

    constexpr BitVector Field28   = 0x10000000;
    constexpr BitVector Field29   = 0x20000000;
    constexpr BitVector Field30   = 0x40000000;
    constexpr BitVector Field31   = 0x80000000;
}

/*! \ingroup GrpSystemFieldContainer
 */

namespace ChangedOrigin
{
    constexpr UInt32 External         = 0x0001;
    constexpr UInt32 Sync             = 0x0002;
    constexpr UInt32 Child            = 0x0004;
    constexpr UInt32 Abstract         = 0x0008;
    constexpr UInt32 SubParent        = 0x0010;

    constexpr UInt32 AbstrIgnoreCore  = 0x0100;
    constexpr UInt32 AbstrIgnoreChild = 0x0200;

    constexpr UInt32 AbstrCheckValid  = 0x0400;
    constexpr UInt32 AbstrIncRefCount = 0x0800;
}

/*! \ingroup GrpSystemFieldContainer
 */

namespace FCDumpFlags
{
    constexpr BitVector RefCount   = 0x00000001;

    constexpr BitVector AllAspects = 0x00000002;

    constexpr BitVector All        = 0xFFFFFFFF;
}

OSG_END_NAMESPACE

#define OSGFIELDCONTAINERBASE_HEADER_CVSID "@(#)$Id: $"

#endif /* _OSGFIELDCONTAINERBASE_H_ */

