
#include "OSGNodeCoreFlags.h"

OSG_BEGIN_NAMESPACE

std::atomic<UInt64> g_ancestorLockTimeStamp = 1; // Must start with 1 because 0 is the default value of uninitialized nodes.
FieldContainerType *g_vredLockType = nullptr;
FieldContainerType *g_assetAttachmentType = nullptr;


// Incremeting the timestamp invalidates Ancestor Lock state of all nodes.
// Ensure it is never 0 (because that is the default of uninitialized nodes).

void invalidateAncestorLockCache() {
    // Increment the atomic variable.
    // Using relaxed memory order is acceptable here because we only need to ensure that
    // the timestamp is incremented. The exact resulting value is not important.
    UInt64 oldValue = g_ancestorLockTimeStamp.fetch_add(1, std::memory_order_relaxed);

    // Ensure it does not wrap around to zero.
    if ((oldValue + 1) == 0u) {
        g_ancestorLockTimeStamp.store(1);
    }
}

void setOpenSGSceneRoot(const osg::NodePtr& root)
{
    if(root != NullFC)
    {
        beginEditCP(root, Node::FlagsFieldMask);
        root->setFlags(root->getFlags() | Node::NFSceneRoot);
        endEditCP(root, Node::FlagsFieldMask);

        invalidateAncestorLockCache();
    }
}


OSG_END_NAMESPACE