#ifndef _OSGNODECOREFLAGS_H_
#define _OSGNODECOREFLAGS_H_
#pragma once

#include <OSGSystemDef.h>
#include <OSGNode.h>
#include <atomic>

OSG_BEGIN_NAMESPACE

//  Helper for NodeCore flag cache

enum : std::uint8_t
{
    CF_CachedFlagDirty = 0,
    CF_CachedFlagTrue = 1,
    CF_CachedFlagFalse = 2,
};

extern OSG_SYSTEMLIB_DLLMAPPING std::atomic<UInt64> g_ancestorLockTimeStamp;
extern OSG_SYSTEMLIB_DLLMAPPING FieldContainerType *g_vredLockType;
extern OSG_SYSTEMLIB_DLLMAPPING FieldContainerType *g_assetAttachmentType;

OSG_SYSTEMLIB_DLLMAPPING void invalidateAncestorLockCache();
OSG_SYSTEMLIB_DLLMAPPING void setOpenSGSceneRoot(const osg::NodePtr& root);


// Is a template so that it works both for NodePtr and Node*
template<typename NodeType>
inline bool queryIsUneditedAssetRoot(const NodeType& node)
{
    if(g_assetAttachmentType == nullptr)
        return false;
    auto assetAttachment = node->findAttachment(*g_assetAttachmentType);
    if(assetAttachment != NullFC)
    {
        Field* userEditedField = assetAttachment->getField("userEdited");
        if (userEditedField != nullptr)
            return !((static_cast<SFBool*>(userEditedField))->getValue());
    }   
    return false;
}

template<typename NodeType>
inline bool queryLock(const NodeType& node)
{
    return (g_vredLockType != nullptr) && node->hasAttachment(*g_vredLockType);
}


OSG_END_NAMESPACE

#endif