#ifndef _OSGNODEFUNCTIONS_H
#define _OSGNODEFUNCTIONS_H
#pragma once

#include <OSGConfig.h>
#include <OSGNode.h>


OSG_BEGIN_NAMESPACE

inline bool hasParent(const osg::NodePtr &node, const osg::NodePtr &parent)
{
    if(node == NullFC || parent == NullFC)
        return false;

    NodePtr n = node->getParent();
    while(n != NullFC)
    {
        if(n == parent)
            return true;
        n = n->getParent();
    }

    return false;
}

inline bool hasParentWithFlag(const osg::NodePtr &node, UInt32 flag)
{
    if(node == NullFC)
        return false;

    NodePtr n = node->getParent();
    while(n != NullFC)
    {
        if(n->hasFlag(flag))
            return true;
        n = n->getParent();
    }

    return false;
}

inline bool isGraphNode(const NodePtr& node, const NodePtr& root)
{
    if(root == NullFC)
        return false;

    return (node != NullFC) &&
        (!node->hasFlag(Node::NFTrash)) &&
        ((node == root) || hasParent(node, root));
}

inline bool isGraphNodeWithFlag(const NodePtr& node, UInt32 flag)
{
    return (node != NullFC) &&
        (!node->hasFlag(Node::NFTrash)) &&
        ((node->hasFlag(flag)) || hasParentWithFlag(node, flag));
}

OSG_END_NAMESPACE

#endif