#ifndef _OSGSCENECHANGES_H_
#define _OSGSCENECHANGES_H_
#pragma once

#include <OSGSystemDef.h>
#include <OSGBaseTypes.h>
#include <OSGNode.h>

OSG_BEGIN_NAMESPACE

class ChangeList;

class OSG_SYSTEMLIB_DLLMAPPING SceneChanges
{
public:
    SceneChanges();
    virtual ~SceneChanges();
    ChangeList *getChangeList();
    void setChangeList(ChangeList *list);
    virtual void collect() = 0;
    virtual void clear() = 0;
    virtual bool hasMoved(const osg::NodePtr &node) = 0;
    virtual bool hasMovedNodes() = 0;
private:
    ChangeList *_changeList;
};

OSG_END_NAMESPACE

#endif // OSGSCENECHANGES_H
