/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *           Copyright (C) 2000,2001,2002 by the OpenSG Forum                *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifdef OSG_DOC_FILES_IN_MODULE
/*! \file OSGSimpleAttachments.cpp
    \ingroup GrpSystemFieldContainer
 */
#endif

#define OSG_COMPILESIMPLEATTACHMENTSINST

#include <stdlib.h>
#include <stdio.h>

#ifndef WIN32
#include <execinfo.h>
#endif

#include "OSGConfig.h"

#include "OSGAttachmentContainer.h"
#include "OSGSimpleAttachments.h"

OSG_USING_NAMESPACE


#ifdef WIN32
OSG_FC_TYPE_FUNCTIONS_INL_TMPL_DEF(AttachmentDescT,
                                   SimpleAttachment);
#endif


/*-------------------------------------------------------------------------*/
/*                          Encoding Attachment                            */

FieldDescription *EncodingAttachmentDesc::_desc[] =
{
    new FieldDescription(
        FieldTypeT::getClassType(),
        getFieldName(),
        OSG_FC_FIELD_IDM_DESC(
            SimpleAttachment<EncodingAttachmentDesc>::SimpleField),
        FieldDescription::FDExternal,
        reinterpret_cast<FieldAccessMethod>(&SimpleAttachment<
                                            EncodingAttachmentDesc>::getFieldPtr))
};

OSG_BEGIN_NAMESPACE

OSG_FC_DLLEXPORT_DEF(SimpleAttachment,
                     EncodingAttachmentDesc,
                     OSG_SYSTEMLIB_DLLTMPLMAPPING);

OSG_END_NAMESPACE

/*-------------------------------------------------------------------------*/
/*                            VoidP Attachment                             */

FieldDescription *VoidPAttachmentDesc::_desc[] =
{
    new FieldDescription(
        FieldTypeT::getClassType(),
        getFieldName(),
        OSG_FC_FIELD_IDM_DESC(
            SimpleAttachment<VoidPAttachmentDesc>::SimpleField),
        FieldDescription::FDExternal,
        reinterpret_cast<FieldAccessMethod>(&SimpleAttachment<
                                            VoidPAttachmentDesc>::getFieldPtr))
};

OSG_BEGIN_NAMESPACE

OSG_FC_DLLEXPORT_DEF(SimpleAttachment,
                     VoidPAttachmentDesc,
                     OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*-------------------------------------------------------------------------*/
/*                   VoidP Attachment Utility Functions                    */

/*!
  Return the void * attached to the container, NULL if none attached or
  container is NULL.
 */

void *getVoidP(AttachmentContainerPtr container)
{
    if(container == NullFC)
        return NULL;

    // Get attachment pointer
    AttachmentPtr att =
       container->findAttachment(VoidPAttachment::getClassType().getGroupId());

    if(att == NullFC)
        return NULL;

    // Cast to name pointer

    VoidPAttachmentPtr pVoid = VoidPAttachmentPtr::dcast(att);

    if(pVoid == NullFC)
        return NULL;

    return pVoid->getFieldPtr()->getValue();
}

/*!
  Set the void * attached to the container. If the container doesn't have a
  VoidP attachement yet one is created.
 */

void setVoidP(AttachmentContainerPtr  container,
              void                   *pData,
              bool                   internal )
{
    if(container == NullFC)
    {
        FFATAL(("setVoidP: no container?!?\n"));
        return;
    }

    // Get attachment pointer

    VoidPAttachmentPtr  pVoid = NullFC;
    AttachmentPtr       att   =
       container->findAttachment(VoidPAttachment::getClassType().getGroupId());

    if(att == NullFC)
    {
        pVoid = VoidPAttachment::create();
        container->addAttachment(pVoid);
    }
    else
    {
        pVoid = VoidPAttachmentPtr::dcast(att);

        if(pVoid == NullFC)
        {
            FFATAL(("setVoidP: VoidP Attachment is not castable "
                    "to VoidPAttachment?!?\n"));
            return;
        }
    }

    pVoid->setInternal(internal);
    pVoid->getFieldPtr()->setValue(pData);
}

OSG_END_NAMESPACE


/*-------------------------------------------------------------------------*/
/*                              cvs id's                                   */

#ifdef __sgi
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp[] = "@(#)$Id: $";
    static Char8 cvsid_hpp[] = OSGSIMPLEATTACHMENTS_HEADER_CVSID;
}

