/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *                     Copyright 2000-2002 by OpenSG Forum                   *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGUNSHAREFUNCTIONS_H_
#define _OSGUNSHAREFUNCTIONS_H_
#pragma once

#ifdef OSG_DOC_FILES_IN_MODULE
/*! \file OSGUnshareFunctions.h
    \ingroup GrpSystemFieldContainer
 */
#endif

#include <string>
#include <vector>

#include <OSGSystemDef.h>
#include <OSGBaseTypes.h>
#include <OSGFieldContainer.h>
#include <OSGSFSysTypes.h>
#include <OSGSFBaseTypes.h>

#include <OSGAttachmentContainer.h>
#include <OSGSFNodeCorePtr.h>
#include <OSGSFNodePtrImpl.h>
#include <OSGSFNodePtrDepImpl.h>
#include <OSGMFNodePtrImpl.h>
#include <OSGMFNodePtrDepImpl.h>

OSG_BEGIN_NAMESPACE


/*! \ingroup GrpSystemFieldContainerFuncs
 */

/*! \brief Unshares the node, not its children, by replacing its core and attachments by deep clones 
*/
OSG_SYSTEMLIB_DLLMAPPING
void unshareNode(const NodePtr& node, 
                 const std::vector<std::string>& share);

/*! \brief Unshares node cores and attachments of the given nodes, not their children.
           Keeps sharing between the nodes of the passed list but severs connection to others.
           Compare deepCloneTreeKeepShared.
    \param share list of FieldContainer Type names to exclude from unsharing.
           Note: Node cores are currently always cloned even when the core type is in "share", same as with deepCloneTree.
*/
OSG_SYSTEMLIB_DLLMAPPING
void unshareNodesKeepLocalShared(std::vector<osg::NodePtr>& nodes, 
                                const std::vector<std::string>& share);


OSG_END_NAMESPACE

#define OSGUNSHAREFUNCTIONS_HEADER_CVSID "@(#)$Id: $"

#endif /* _OSGUNSHAREFUNCTIONS_H_ */
