/*---------------------------------------------------------------------------*\
*                                OpenSG                                     *
*                                                                           *
*                                                                           *
*             Copyright (C) 2000-2002 by the OpenSG Forum                   *
*                                                                           *
*                            www.opensg.org                                 *
*                                                                           *
*   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
*                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
*                                License                                    *
*                                                                           *
* This library is free software; you can redistribute it and/or modify it   *
* under the terms of the GNU Library General Public License as published    *
* by the Free Software Foundation, version 2.                               *
*                                                                           *
* This library is distributed in the hope that it will be useful, but       *
* WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
* Library General Public License for more details.                          *
*                                                                           *
* You should have received a copy of the GNU Library General Public         *
* License along with this library; if not, write to the Free Software       *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
*                                Changes                                    *
*                                                                           *
*                                                                           *
*                                                                           *
*                                                                           *
*                                                                           *
*                                                                           *
\*---------------------------------------------------------------------------*/


#ifndef _OSGGRAPHOPSEQ_H_
#define _OSGGRAPHOPSEQ_H_
#pragma once

#include <OSGConfig.h>

#include <OSGSystemDef.h>
#include <OSGNodePtr.h>
#include <OSGAction.h>
#include <OSGGraphOp.h>
#include <vector>
#include <memory>

OSG_BEGIN_NAMESPACE

//! \ingroup GrpSystemRenderingBackend
//! GraphOpSeq class

class OSG_SYSTEMLIB_DLLMAPPING GraphOpSeq
{
    /*==========================  PUBLIC  =================================*/
public:

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static const char *getClassname(void) { return "GraphOpSeq"; };

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */
    
    GraphOpSeq(void);
    GraphOpSeq( GraphOpSeq&& other);
    GraphOpSeq(const std::string params);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    ~GraphOpSeq(void);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Main methods                               */
    /*! \{                                                                 */

    bool run(const NodePtr &root);

    /*! \}                                                                 */

    void setGraphOps(const std::string params);     

    void addGraphOp            (std::unique_ptr<GraphOp>& op                 );
    void clearGraphOps         (void                        );

    UInt16      getSize        (void                        );

    /*=========================  PROTECTED  ===============================*/
protected:    

    /*==========================  PRIVATE  ================================*/
private:
    std::vector< std::unique_ptr<GraphOp> > _GraphOperators;
    std::list<std::string> _excludeNames;

    UInt16 extractStr(const std::string param, 
                            UInt16 spos, 
                      const char* delim, 
                            std::string& result);
};

typedef GraphOpSeq *GraphOpSeqP;

OSG_END_NAMESPACE

#endif /* _OSGGRAPHOPSEQ_H_ */
