/*
 * Copyright(c) PI-VR GmbH
 * http://www.pi-vr.com
 *
 * For information about the licensing and copyright of this code please
 * contact PI-VR GmbH at info@pi-vr.com.
 *
 */

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGImageAttachment.h"

OSG_BEGIN_NAMESPACE

/***************************************************************************\
 *                            Description                                  *
\***************************************************************************/

/*! \class osg::ImageAttachment

*/

/***************************************************************************\
 *                           Class variables                               *
\***************************************************************************/

/***************************************************************************\
 *                           Class methods                                 *
\***************************************************************************/

void ImageAttachment::initMethod (void)
{
}


/***************************************************************************\
 *                           Instance methods                              *
\***************************************************************************/

/*-------------------------------------------------------------------------*\
 -  private                                                                 -
\*-------------------------------------------------------------------------*/

/*----------------------- constructors & destructors ----------------------*/

ImageAttachment::ImageAttachment(void) :
    Inherited()
{
}

ImageAttachment::ImageAttachment(const ImageAttachment &source) :
    Inherited(source)
{
}

ImageAttachment::~ImageAttachment(void)
{
}

void ImageAttachment::onDestroy(void)
{
    Inherited::onDestroy();
    subRefCP(_sfImage.getValue());
}

/*----------------------------- class specific ----------------------------*/

void ImageAttachment::changed(BitVector whichField, UInt32 origin)
{
    if(whichField & ImageFieldMask)
    {
        
    }

    Inherited::changed(whichField, origin);
}

void ImageAttachment::dump(      UInt32    , 
                         const BitVector ) const
{
    SLOG << "Dump ImageAttachment NI" << std::endl;
}

OSG_END_NAMESPACE

