/*
 * Copyright(c) PI-VR GmbH
 * http://www.pi-vr.com
 *
 * For information about the licensing and copyright of this code please
 * contact PI-VR GmbH at info@pi-vr.com.
 *
 */

#ifndef _OSGRIMAGEATTACHMENT_H_
#define _OSGRIMAGEATTACHMENT_H_
#pragma once

#include <OSGConfig.h>

#include <OSGImageAttachmentBase.h>

OSG_BEGIN_NAMESPACE

/*! \brief ImageAttachment class. See \ref 
           PageOpenSGUberMaterialImageAttachment for a description.
*/

class OSG_SYSTEMLIB_DLLMAPPING ImageAttachment : public ImageAttachmentBase
{
  private:

    typedef ImageAttachmentBase Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    /*---------------------------------------------------------------------*/
    /*! \name                      Sync                                    */
    /*! \{                                                                 */

    virtual void changed(BitVector  whichField, 
                         UInt32     origin    );

    void setImage(const ImagePtr &value);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     Output                                   */
    /*! \{                                                                 */

    virtual void dump(      UInt32     uiIndent = 0, 
                      const BitVector  bvFlags  = 0) const;

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    // Variables should all be in ImageAttachmentBase.

    /*---------------------------------------------------------------------*/
    /*! \name                  Constructors                                */
    /*! \{                                                                 */

    ImageAttachment(void);
    ImageAttachment(const ImageAttachment &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~ImageAttachment(void); 

    void onDestroy(void);

    /*! \}                                                                 */
    
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;
    friend class ImageAttachmentBase;

    void operator =(const ImageAttachment &source);

    static void initMethod(void);

    // prohibit default functions (move to 'public' if you need one)
};

typedef ImageAttachment *ImageAttachmentP;

OSG_END_NAMESPACE

#include <OSGImageAttachmentBase.inl>
#include <OSGImageAttachment.inl>

#endif /* _OSGIMAGEATTACHMENT_H_ */
