
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef OSGIMAGECOMPRESSOR_CLASS_DECLARATION
#define OSGIMAGECOMPRESSOR_CLASS_DECLARATION
#ifdef  __sgi
#pragma  once
#endif

#include <memory>

#include <OSGSystemDef.h>
#include <OSGBaseTypes.h>

#include "OSGImage.h"

OSG_BEGIN_NAMESPACE

class OSG_SYSTEMLIB_DLLMAPPING ImageCompressor
{
public:
    ImageCompressor();
    ~ImageCompressor(); // Needed for the unique_ptr to the incomplete type

    // Prevent copy operations
    ImageCompressor(const ImageCompressor&) = delete;
    ImageCompressor& operator=(const ImageCompressor&) = delete;

    // Allow move operations
    ImageCompressor(ImageCompressor&&) noexcept;
    ImageCompressor& operator=(ImageCompressor&&) noexcept;

    bool setImage(const ImagePtr& image);
    bool getImage(ImagePtr& image, UInt32 pixelFormat) const;
    bool getImage(ImagePtr& image) const;
    bool getData(std::vector<UInt8>& data, Int32 format, Int32 type) const;

    bool compress(ImagePtr& image);

    void convertCubemapLayoutFromDXToOGL();
    void createMipmaps();

    void write(const std::string& filename) const;

private:
    class SurfaceSet;
    std::unique_ptr<SurfaceSet> _surfaceSet;
};

OSG_END_NAMESPACE

#endif // OSGIMAGECOMPRESSOR_CLASS_DECLARATION
