
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGHITPOINT_H_
#define _OSGHITPOINT_H_

#include <OSGBaseTypes.h>
#include <OSGVector.h>
#include <OSGMatrix.h>

OSG_BEGIN_NAMESPACE

class HitPoint
{
public:
    Pnt2f uv;
    Pnt3f oP; // object space position
    Vec3f oN; // object space normal
    Matrix objectToTexture; // object to texture projection space
};

OSG_END_NAMESPACE

#endif
