/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGMultiMaterial.h"

OSG_BEGIN_NAMESPACE

/***************************************************************************\
 *                            Description                                  *
\***************************************************************************/

/*! \class osg::MultiMaterial

*/

/***************************************************************************\
 *                           Class variables                               *
\***************************************************************************/

/***************************************************************************\
 *                           Class methods                                 *
\***************************************************************************/

void MultiMaterial::initMethod (void)
{
}


/***************************************************************************\
 *                           Instance methods                              *
\***************************************************************************/

/*-------------------------------------------------------------------------*\
 -  private                                                                 -
\*-------------------------------------------------------------------------*/

/*----------------------- constructors & destructors ----------------------*/

MultiMaterial::MultiMaterial(void) :
    Inherited()
{
}

MultiMaterial::MultiMaterial(const MultiMaterial &source) :
    Inherited(source)
{
}

MultiMaterial::~MultiMaterial(void)
{
    MFMaterialPtr::iterator       matIt = _mfMaterials.begin();
    MFMaterialPtr::const_iterator matEnd = _mfMaterials.end();

    while (matIt != matEnd)
    {
        subRefCP(*matIt);
        ++matIt;
    }
    _mfMaterials.clear();
}

/*----------------------------- class specific ----------------------------*/

void MultiMaterial::changed(BitVector whichField, UInt32 origin)
{
    Inherited::changed(whichField, origin);
}

void MultiMaterial::dump(      UInt32    , 
                         const BitVector ) const
{
    SLOG << "Dump MultiMaterial NI" << std::endl;
}

void MultiMaterial::addMaterial(const MaterialPtr & material)
{
    insertMaterial(material, _mfMaterials.size());
}

void MultiMaterial::insertMaterial(const MaterialPtr & material, int index)
{
    if (material == NullFC)
        return;

    if (material->hasMaterial(MaterialPtr(this), Material::AllRecursiveChildMaterials))
    {
        SFATAL << "MultiMaterial::addMaterial(" << this << ") Material could not be added. Cycle detected" << endLog;
        return;
    }

    if ( index < 0 || index > _mfMaterials.size() )
        index = _mfMaterials.size();

    if ( index == _mfMaterials.size() )
    {
        _mfMaterials.push_back(material);
    }
    else
    {
        _mfMaterials.insert(_mfMaterials.begin()+index, material);
    }
    addRefCP(material);
}

void MultiMaterial::subMaterial(const MaterialPtr &  material)
{
    if (material == NullFC)
        return;

    UInt32 i;

    for (i = 0; i < _mfMaterials.size(); ++i)
    {
        if (_mfMaterials[i] == material)
        {
            subRefCP(material);
            _mfMaterials.erase(_mfMaterials.begin() + i);
            return;
        }
    }

    SWARNING << "MultiMaterial::subMaterial(" << this << ") has no material "
        << material << std::endl;
}

bool MultiMaterial::hasMaterial(const MaterialPtr &searchMaterial, SearchMaterialOption searchMode) const
{
    if ( searchMaterial == NullFC )
        return false;

    if ( this == searchMaterial.getCPtr() )
        return true;

    for (const auto & subMaterial : _mfMaterials)
    {
        if (subMaterial == searchMaterial)
            return true;

        if (searchMode == Material::AllRecursiveChildMaterials && subMaterial->hasMaterial(searchMaterial, searchMode))
            return true;
    }
    return false;
}

/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCTemplate_cpp.h,v 1.20 2006/03/16 17:01:53 dirk Exp $";
    static Char8 cvsid_hpp       [] = OSGMULTIMATERIALBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGMULTIMATERIALBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGMULTIMATERIALFIELDS_HEADER_CVSID;
}

#ifdef __sgi
#pragma reset woff 1174
#endif

OSG_END_NAMESPACE

