/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>
#include <OSGTransform3D.h>

#include "OSGDrawable.h"

OSG_USING_NAMESPACE

/*! \class osg::Drawable

*/

/*----------------------------- class variables ---------------------------*/

StatElemDesc<StatUInt64Elem>  Drawable::statNTriangles("NTriangles",
"number of rendered triangles");
StatElemDesc<StatUInt64Elem>  Drawable::statNLines("NLines",
"number of rendered lines");
StatElemDesc<StatUInt64Elem>  Drawable::statNPoints("NPoints",
"number of rendered points");
StatElemDesc<StatUInt64Elem>  Drawable::statNVertices("NVertices",
"number of transformed vertices");
StatElemDesc<StatUInt64Elem>  Drawable::statNPrimitives("NPrimitives",
"number of rendered primitive groups");
StatElemDesc<StatIntOnceElem>  Drawable::statNGeoBytes("NGeoBytes",
"memory usages of geometry on the gfx card");

/*----------------------- constructors & destructors ----------------------*/

//! Constructor

Drawable::Drawable(void) :
    Inherited()
{
}

//! Copy Constructor

Drawable::Drawable(const Drawable &source) :
    Inherited(source)
{
}

//! Destructor

Drawable::~Drawable(void)
{
}

/*----------------------------- class specific ----------------------------*/

void Drawable::onCreate(const Drawable *source)
{
    // if we're in startup this is the prototype, which shouldn't have an id
    if(GlobalSystemState == Startup)
        return;
    /*
    DrawablePtr tmpPtr(*this);

    // ok calling tmpPtr->setTransform() leads to crash while loading a vrml file,
    // the vrml loader calls shallowCopy()
    beginEditCP(tmpPtr, Drawable::TransformFieldMask);
        Transform3DPtr t3d = Transform3D::create();
        t3d->setAssociatedCore(tmpPtr); // set the core reference
        addRefCP(t3d);
        _sfTransform.setValue(t3d);
    endEditCP(tmpPtr, Drawable::TransformFieldMask);*/
}

void Drawable::onDestroy(void)
{
    if( getTransform() != NullFC)
        getTransform()->setAssociatedCore(NullFC);
    subRefCP(_sfTransform.getValue());
    Inherited::onDestroy();
}

//! initialize the static features of the class, e.g. action callbacks

void Drawable::initMethod (void)
{
}

Transform3DPtr Drawable::getTransformCore()
{
    if (getTransform() == NullFC)
    {
        DrawablePtr tmpPtr(*this);
        // ok calling tmpPtr->setTransform() leads to crash while loading a vrml file,
        // the vrml loader calls shallowCopy()
        beginEditCP(tmpPtr, Drawable::TransformFieldMask);
        Transform3DPtr t3d = Transform3D::create();
        t3d->setAssociatedCore(tmpPtr); // set the core reference
        addRefCP(t3d);
        _sfTransform.setValue(t3d);
        endEditCP(tmpPtr, Drawable::TransformFieldMask);
    }
    return getTransform();
}

//! react to field changes

void Drawable::changed(BitVector whichField, UInt32 origin)
{
    if(whichField & TransformFieldMask)
    {
        
        DrawablePtr tmpPtr(*this);
        Transform3DPtr pTrans = _sfTransform.getValue();
        if( pTrans != NullFC)
            pTrans->setAssociatedCore(tmpPtr); // set the core reference
        invalidateVolume();
    }

    Inherited::changed(whichField, origin);
}

void Drawable::accumulateMatrix(Matrix &result)
{
    Transform3DPtr trans = _sfTransform.getValue();
    if( trans != NullFC && !(trans->isIdentity()))
        result.mult(trans->getMatrix());
}

//! output the instance for debug purposes

void Drawable::dump(      UInt32    ,
                         const BitVector ) const
{
    SLOG << "Dump Drawable NI" << std::endl;
}


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGDrawable.cpp,v 1.7 2007/05/31 10:48:57 a-m-z Exp $";
    static Char8 cvsid_hpp       [] = OSGDRAWABLEBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGDRAWABLEBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGDRAWABLEFIELDS_HEADER_CVSID;
}

#ifdef __sgi
#pragma reset woff 1174
#endif

