/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *                     Copyright 2000-2002 by OpenSG Forum                   *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------


#include <stdlib.h>
#include <stdio.h>

#include "OSGConfig.h"

OSG_BEGIN_NAMESPACE

/***************************************************************************\
 *                           Instance methods                              *
\***************************************************************************/

/*-------------------------------------------------------------------------*\
 -  public                                                                 -
\*-------------------------------------------------------------------------*/

/*------------------------------ access -----------------------------------*/

inline
void Geometry::setTypes(const GeoPTypesPtr &value)
{
    GeometryPtr thisP = getPtr();

    addRefCP(value);

    if(_sfTypes.getValue() != NullFC)
    {
        beginEditCP(_sfTypes.getValue(), Attachment::ParentsFieldMask);
        {
            _sfTypes.getValue()->subParent(thisP);
        }
        endEditCP(_sfTypes.getValue(), Attachment::ParentsFieldMask);

        subRefCP(_sfTypes.getValue());
    }

    if(value != NullFC)
    {
        thisP.setParentFieldPos(TypesFieldId);

        beginEditCP(value, Attachment::ParentsFieldMask);
        {
            value->addParent(thisP);
        }
        endEditCP(value, Attachment::ParentsFieldMask);
    }

    _sfTypes.setValue(value);
}

inline
void Geometry::setLengths(const GeoPLengthsPtr &value)
{
    GeometryPtr thisP = getPtr();

    addRefCP(value);

    if(_sfLengths.getValue() != NullFC)
    {
        beginEditCP(_sfLengths.getValue(), Attachment::ParentsFieldMask);
        {
            _sfLengths.getValue()->subParent(thisP);
        }
        endEditCP(_sfLengths.getValue(), Attachment::ParentsFieldMask);

        subRefCP(_sfLengths.getValue());
    }

    if(value != NullFC)
    {
        thisP.setParentFieldPos(LengthsFieldId);

        beginEditCP(value, Attachment::ParentsFieldMask);
        {
            value->addParent(thisP);
        }
        endEditCP(value, Attachment::ParentsFieldMask);
    }

    _sfLengths.setValue(value);
}

inline
void Geometry::setPositions(const GeoPositionsPtr &value)
{
    GeometryPtr thisP = getPtr();

    addRefCP(value);

    if(_sfPositions.getValue() != NullFC)
    {
        beginEditCP(_sfPositions.getValue(), Attachment::ParentsFieldMask);
        {
            _sfPositions.getValue()->subParent(thisP);
        }
        endEditCP(_sfPositions.getValue(), Attachment::ParentsFieldMask);

        subRefCP(_sfPositions.getValue());
    }

    if(value != NullFC)
    {
        thisP.setParentFieldPos(PositionsFieldId);

        beginEditCP(value, Attachment::ParentsFieldMask);
        {
            value->addParent(thisP);
        }
        endEditCP(value, Attachment::ParentsFieldMask);
    }

    _sfPositions.setValue(value);
}

inline
void Geometry::setNormals(const GeoNormalsPtr &value)
{
    GeometryPtr thisP = getPtr();

    addRefCP(value);

    if(_sfNormals.getValue() != NullFC)
    {
        beginEditCP(_sfNormals.getValue(), Attachment::ParentsFieldMask);
        {
            _sfNormals.getValue()->subParent(thisP);
        }
        endEditCP(_sfNormals.getValue(), Attachment::ParentsFieldMask);

        subRefCP(_sfNormals.getValue());
    }

    if(value != NullFC)
    {
        thisP.setParentFieldPos(NormalsFieldId);

        beginEditCP(value, Attachment::ParentsFieldMask);
        {
            value->addParent(thisP);
        }
        endEditCP(value, Attachment::ParentsFieldMask);
    }

    _sfNormals.setValue(value);
}

inline
void Geometry::setColors(const GeoColorsPtr &value)
{
    GeometryPtr thisP = getPtr();

    addRefCP(value);

    if(_sfColors.getValue() != NullFC)
    {
        beginEditCP(_sfColors.getValue(), Attachment::ParentsFieldMask);
        {
            _sfColors.getValue()->subParent(thisP);
        }
        endEditCP(_sfColors.getValue(), Attachment::ParentsFieldMask);

        subRefCP(_sfColors.getValue());
    }

    if(value != NullFC)
    {
        thisP.setParentFieldPos(ColorsFieldId);

        beginEditCP(value, Attachment::ParentsFieldMask);
        {
            value->addParent(thisP);
        }
        endEditCP(value, Attachment::ParentsFieldMask);
    }

    _sfColors.setValue(value);
}

inline
void Geometry::setSecondaryColors(const GeoColorsPtr &value)
{
    GeometryPtr thisP = getPtr();

    addRefCP(value);

    if(_sfSecondaryColors.getValue() != NullFC)
    {
        beginEditCP(_sfSecondaryColors.getValue(), Attachment::ParentsFieldMask);
        {
            _sfSecondaryColors.getValue()->subParent(thisP);
        }
        beginEditCP(_sfSecondaryColors.getValue(), Attachment::ParentsFieldMask);

        subRefCP(_sfSecondaryColors.getValue());
    }

    if(value != NullFC)
    {
        thisP.setParentFieldPos(SecondaryColorsFieldId);

        beginEditCP(value, Attachment::ParentsFieldMask);
        {
            value->addParent(thisP);
        }
        beginEditCP(value, Attachment::ParentsFieldMask);
    }

    _sfSecondaryColors.setValue(value);
}

inline
void Geometry::setTexCoords(const GeoTexCoordsPtr &value)
{
    setTexSlot(value, 0);
}

inline
void Geometry::setTexCoords1(const GeoTexCoordsPtr &value)
{
    setTexSlot(value, 1);
}

inline
void Geometry::setTexCoords2(const GeoTexCoordsPtr &value)
{
    setTexSlot(value, 2);
}

inline
void Geometry::setTexCoords3(const GeoTexCoordsPtr &value)
{
    setTexSlot(value, 3);
}

inline
void Geometry::setTexCoords4(const GeoTexCoordsPtr &value)
{
    setTexSlot(value, 4);
}

inline
void Geometry::setTexCoords5(const GeoTexCoordsPtr &value)
{
    setTexSlot(value, 5);
}

inline
void Geometry::setTexCoords6(const GeoTexCoordsPtr &value)
{
    setTexSlot(value, 6);
}

inline
void Geometry::setTexCoords7(const GeoTexCoordsPtr &value)
{
    setTexSlot(value, 7);
}

inline
void Geometry::setIndices(const GeoIndicesPtr &value)
{
    GeometryPtr thisP = getPtr();

    addRefCP(value);

    if(_sfIndices.getValue() != NullFC)
    {
        beginEditCP(_sfIndices.getValue(), Attachment::ParentsFieldMask);
        {
            _sfIndices.getValue()->subParent(thisP);
        }
        endEditCP(_sfIndices.getValue(), Attachment::ParentsFieldMask);

        subRefCP(_sfIndices.getValue());
    }

    if(value != NullFC)
    {
        thisP.setParentFieldPos(IndicesFieldId);

        beginEditCP(value, Attachment::ParentsFieldMask);
        {
            value->addParent(thisP);
        }
        endEditCP(value, Attachment::ParentsFieldMask);
    }

    _sfIndices.setValue(value);
}

inline
void Geometry::setMaterial(const MaterialPtr &value)
{
    setRefdCP(_sfMaterial.getValue(), value);
}

inline bool Geometry::isShell() const
{
    return (getGeometryType() & Geometry::GEOMETRY_TYPE_SHELL) ? true : false;
}

inline bool Geometry::isBSide() const
{
    return (getGeometryType() & Geometry::GEOMETRY_IS_B_SIDE) ? true : false;
}

inline void Geometry::setToBSide(bool bSide)
{
    GeometryPtr thisP = getPtr();

    if( bSide && !thisP->isBSide())
    {
        beginEditCP( thisP, osg::Geometry::GeometryTypeFieldMask);
        thisP->setGeometryType( thisP->getGeometryType() | osg::Geometry::GEOMETRY_IS_B_SIDE);
        endEditCP( thisP, osg::Geometry::GeometryTypeFieldMask);
    }
    else if( !bSide && thisP->isBSide())
    {
        beginEditCP( thisP, osg::Geometry::GeometryTypeFieldMask);
        thisP->setGeometryType( thisP->getGeometryType() & ~osg::Geometry::GEOMETRY_IS_B_SIDE);
        endEditCP( thisP, osg::Geometry::GeometryTypeFieldMask);
    }
}

inline void Geometry::setVertexBufferObject(vrVertexBufferObject* vbo)
{
    m_vbo = vbo;
}

inline vrVertexBufferObject* Geometry::getVertexBufferObject() const
{
    return m_vbo;
}

inline void Geometry::setVolumeCacheFunctions(GetVolumeCacheFunction getVolumeFunction, 
                                              InvalidateVolumeCacheFunction invalidateVolumeFunction)
{
    _volumeCache.setEmpty();

    m_getVolume = getVolumeFunction;
    m_invalidateVolume = invalidateVolumeFunction;
}

inline
void Geometry::setTexSlot(const GeoTexCoordsPtr &value, osg::UInt32 slot)
{
    GeometryPtr thisP = getPtr();

    addRefCP(value);

    SFGeoTexCoordsPtr & currentField = getTexSlotField(slot);
    GeoTexCoordsPtr current = currentField.getValue();

    if (current != NullFC)
    {
        beginEditCP(current, Attachment::ParentsFieldMask);
        {
            current->subParent(thisP);
        }
        endEditCP(current, Attachment::ParentsFieldMask);

        subRefCP(current);
    }

    if (value != NullFC)
    {
        thisP.setParentFieldPos(getTexSlotFieldId(slot));

        beginEditCP(value, Attachment::ParentsFieldMask);
        {
            value->addParent(thisP);
        }
        endEditCP(value, Attachment::ParentsFieldMask);
    }

    beginEditCP(thisP, Geometry::getTexSlotFieldMask(slot));
    currentField.setValue(value);
    endEditCP(thisP, Geometry::getTexSlotFieldMask(slot));

}

inline 
SFGeoTexCoordsPtr & Geometry::getTexSlotField(osg::UInt32 slot)
{
    switch (slot)
    {
    default:
    case 0:
        return _sfTexCoords;
    case 1:
        return _sfTexCoords1;
    case 2:
        return _sfTexCoords2;
    case 3:
        return _sfTexCoords3;
    case 4:
        return _sfTexCoords4;
    case 5:
        return _sfTexCoords5;
    case 6:
        return _sfTexCoords6;
    case 7:
        return _sfTexCoords7;
    }
}

inline
GeoTexCoordsPtr Geometry::getTexSlot(osg::UInt32 slot)
{
    return getTexSlotField(slot).getValue();
}

inline
osg::UInt16 Geometry::getIndexMappingConstant(osg::UInt32 slot)
{
    switch(slot)
    {
    default:
    case 0:
        return MapTexCoords;
    case 1:
        return MapTexCoords1;
    case 2:
        return MapTexCoords2;
    case 3:
        return MapTexCoords3;
    case 4:
        return MapTexCoords4;
    case 5:
        return MapTexCoords5;
    case 6:
        return MapTexCoords6;
    case 7:
        return MapTexCoords7;
    }
}

inline 
osg::BitVector Geometry::getTexSlotFieldMask(osg::UInt32 slot)
{
    switch (slot)
    {
    default:
    case 0:
        return TexCoordsFieldMask;
    case 1:
        return TexCoords1FieldMask;
    case 2:
        return TexCoords2FieldMask;
    case 3:
        return TexCoords3FieldMask;
    case 4:
        return TexCoords4FieldMask;
    case 5:
        return TexCoords5FieldMask;
    case 6:
        return TexCoords6FieldMask;
    case 7:
        return TexCoords7FieldMask;
    }
}

inline
osg::UInt16 Geometry::getTexSlotFieldId(osg::UInt32 slot)
{
    switch (slot)
    {
    default:
    case 0:
        return TexCoordsFieldId;
    case 1:
        return TexCoords1FieldId;
    case 2:
        return TexCoords2FieldId;
    case 3:
        return TexCoords3FieldId;
    case 4:
        return TexCoords4FieldId;
    case 5:
        return TexCoords5FieldId;
    case 6:
        return TexCoords6FieldId;
    case 7:
        return TexCoords7FieldId;
    }
}

OSG_END_NAMESPACE

#define OSGGEOMETRY_INLINE_CVSID "@(#)$Id: $"

