/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/
#pragma once

#ifndef _OSG_DATABASE_H_
#define _OSG_DATABASE_H_

#include <OSGConfig.h>
#include <OSGSystemDef.h>
#include "OSGDatabaseBase.h"

#include <map>
#include <string>

OSG_BEGIN_NAMESPACE

/*! \brief Database class. See \ref 
           PageOpenSGUberMaterialDatabase for a description.
*/

class OSG_SYSTEMLIB_DLLMAPPING Database : public DatabaseBase
{
  private:

    typedef DatabaseBase Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    /*---------------------------------------------------------------------*/
    /*! \name                      Sync                                    */
    /*! \{                                                                 */

    virtual void changed(BitVector  whichField, 
                         UInt32     origin    );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     Output                                   */
    /*! \{                                                                 */

    virtual void dump(      UInt32     uiIndent = 0, 
                      const BitVector  bvFlags  = 0) const;

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                     Access                                   */
    /*! \{                                                                 */

    void initLookupTable();

    DatabaseEntryPtr getEntry(const std::string& uuid);
    bool addEntry(const DatabaseEntryPtr & databaseEntry);
    bool deleteEntry(const DatabaseEntryPtr & databaseEntry);
    bool mergeDatabase(const DatabasePtr& other);
    void clearAllEntries();

    const std::map<std::string, DatabaseEntryPtr>& getAllEntries() { return m_map; }

    bool hasEntry(const std::string& uuid);

    /*! \}                                                                 */


    /*=========================  PROTECTED  ===============================*/
  protected:

    // Variables should all be in DatabaseBase.

    /*---------------------------------------------------------------------*/
    /*! \name                  Constructors                                */
    /*! \{                                                                 */

    Database(void);
    Database(const Database &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~Database(void); 

    void onDestroy(void);

    /*! \}                                                                 */
    
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;
    friend class DatabaseBase;

    static void initMethod(void);

    // prohibit default functions (move to 'public' if you need one)

    void operator =(const Database &source);

    std::map<std::string, DatabaseEntryPtr> m_map;
};

typedef Database *DatabaseP;

OSG_END_NAMESPACE

#include "OSGDatabaseBase.inl"
#include "OSGDatabase.inl"

#define OSGUSUBSTANCEGRAPH_HEADER_CVSID "@(#)$Id: FCTemplate_h.h,v 1.23 2005/03/05 11:27:26 dirk Exp $"

#endif /* _OSGUSUBSTANCEGRAPH_H_ */
