/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGMATERIALPOOL_H_
#define _OSGMATERIALPOOL_H_

#pragma once

#include <set>
#include <vector>

#include <OSGConfig.h>
#include <OSGSystemDef.h>
#include <OSGMaterialPoolBase.h>
#include <OSGAction.h>
#include <OSGDatabase.h>

OSG_BEGIN_NAMESPACE

class OSG_SYSTEMLIB_DLLMAPPING MaterialPool : public MaterialPoolBase
{
    /*==========================  PUBLIC  =================================*/
  public:

    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    virtual void changed(BitVector whichField,
                         UInt32    origin    );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Access                                    */
    /*! \{                                                                 */

    void    sync     (void                          );

    SizeT   getCount (void                          ) const;
    bool    isEmpty  (void                          ) const;

    bool    add      (const MaterialPtr &mat);
    bool    add      (const MaterialPtr &mat, const NodePtr &parent, bool create_node, const UInt32 pos);
    void    add      (const NodePtr &root           );
    void    add      (const MaterialPoolPtr &mp     );

    Int32   find     (const MaterialPtr &mat        ) const;
    NodePtr find     (const NodePtr &node, const MaterialPtr &mat) const;
    void    find     (std::vector<NodePtr> &nodes, const NodePtr &node, const MaterialPtr &mat) const;

    void    replace  (const MaterialPtr &old_mat, const MaterialPtr &new_mat);

    void    sub      (const MaterialPtr &mat        );
    void    sub      (      UInt32   mat            );

    MaterialPtr get  (      UInt32   index          );
    void        get  (std::vector<MaterialPtr> &mats);
    const std::set<MaterialPtr> &get(void);

    void    clear    (void                          );

    void    setRoot(const NodePtr &value);
    void    setLightRoot(const NodePtr &value);
    void    setLightSetsRoot(const NodePtr &value);
    void    setOverlayRoot (const NodePtr &value);
    void    setSceneplateRoot(const NodePtr &value);
    void    setPhysicsRoot(const NodePtr &value);
    void    setConstraintsRoot(const NodePtr &value);
    void    setCameraRoot(const NodePtr &value);
    void    setAnnotationRoot(const NodePtr &value);
    void    setResourceDatabase(const DatabasePtr &value);

    void    initMaterialRoot();
    void    initLightSetsRoot();
    void    initLightRoot();
    void    initOverlayRoot();
    void    initSceneplateRoot();
    void    initPhysicsRoot();
    void    initConstraintsRoot();
    void    initCameraRoot();
    void    initAnnotationRoot();
    void    initResourceDatabase();

    osg::NodePtr getMaterialGroupRoot();

    void    addCameras(const MaterialPoolPtr &src);
    void    addConstraints(const MaterialPoolPtr &src);
    void    addLights(const MaterialPoolPtr &src);
    void    addLightSets(const MaterialPoolPtr &src);
    void    addOverlays(const MaterialPoolPtr &src);
    // returns added scene plate "root" nodes
    std::vector<NodePtr> addSceneplates(const MaterialPoolPtr &src);
    void    addPhysics(const MaterialPoolPtr &src);
    void    addAnnotations(const MaterialPoolPtr &src);
    void    addResourceDatabase(const MaterialPoolPtr &src);
    void    addMetadata(const MaterialPoolPtr &src);

    bool    addMetadataSet(const AttachmentContainerPtr &value);
    bool    removeMetadataSet(const AttachmentContainerPtr &value);
    bool    containsMetadataSet(const AttachmentContainerPtr &value);
    void    clearMetadataSets();


    void removeInvalidMaterialGroups();

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                        Dump                                  */
    /*! \{                                                                 */

    virtual void dump(      UInt32    uiIndent = 0,
                      const BitVector bvFlags  = 0) const;

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    typedef MaterialPoolBase Inherited;

    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    MaterialPool(void);
    MaterialPool(const MaterialPool &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~MaterialPool(void);

    void onDestroy(void);

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;
    friend class MaterialPoolBase;

    /*---------------------------------------------------------------------*/
    /*! \name                       Init                                   */
    /*! \{                                                                 */

    static void initMethod(void);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/

    /*!\brief prohibit default function (move to 'public' if needed) */
    void operator =(const MaterialPool &source);

    osg::Action::ResultE addMaterialCB(const osg::NodePtr &node);

    std::set<MaterialPtr> _mats;
};

typedef MaterialPool *MaterialPoolP;

OSG_END_NAMESPACE

#include <OSGMaterialPoolBase.inl>
#include <OSGMaterialPool.inl>

#define OSGMATERIALPOOL_HEADER_CVSID "@(#)$Id: OSGMaterialPool.h,v 1.1 2005/04/30 15:03:20 a-m-z Exp $"

#endif /* _OSGMATERIALPOOL_H_ */
