/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *                     Copyright 2000-2002 by OpenSG Forum                   *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>

#include "OSGConfig.h"

OSG_BEGIN_NAMESPACE

inline
SizeT MaterialPool::getCount(void) const
{
    return _mfMaterials.size();
}
 
inline
MaterialPtr MaterialPool::get(UInt32 index)
{
    OSG_ASSERT((index < _mfMaterials.size()));

    return _mfMaterials[index];
}

inline
void MaterialPool::setRoot(const NodePtr &value)
{
    setRefdCP(_sfRoot.getValue(), value);
}

inline
    void MaterialPool::setLightRoot(const NodePtr &value)
{
    setRefdCP(_sfLightRoot.getValue(), value);
}

inline
void MaterialPool::setLightSetsRoot(const NodePtr &value)
{
    setRefdCP(_sfLightSetsRoot.getValue(), value);
}

inline
void MaterialPool::setOverlayRoot(const NodePtr &value)
{
    setRefdCP(_sfOverlayRoot.getValue(), value);
}

inline
void MaterialPool::setSceneplateRoot(const NodePtr &value)
{
    setRefdCP(_sfSceneplateRoot.getValue(), value);
}

inline
void MaterialPool::setPhysicsRoot(const NodePtr &value)
{
    setRefdCP(_sfPhysicsRoot.getValue(), value);
}

inline
void MaterialPool::setConstraintsRoot(const NodePtr &value)
{
    setRefdCP(_sfConstraintsRoot.getValue(), value);
}

inline
void MaterialPool::setCameraRoot(const NodePtr &value)
{
    setRefdCP(_sfCameraRoot.getValue(), value);
}

inline
void MaterialPool::setAnnotationRoot(const NodePtr &value)
{
    setRefdCP(_sfAnnotationRoot.getValue(), value);
}

inline
void MaterialPool::setResourceDatabase(const DatabasePtr &value)
{
    setRefdCP(_sfResourceDatabase.getValue(), value);
}

OSG_END_NAMESPACE

#define OSGMATERIALPOOL_INLINE_CVSID "@(#)$Id: OSGMaterialPool.inl,v 1.1 2005/04/30 15:03:20 a-m-z Exp $"
