/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>

#include "OSGConfig.h"

#include <OSGGL.h>

#include <OSGDrawAction.h>
#include <OSGIntersectAction.h>
#include <OSGRenderAction.h>

#include "OSGTransform.h"

OSG_USING_NAMESPACE

/*! \class osg::Transform

  The basic Transformation class. Just keeps a single matrix. For more complex
  behaviour, see its descendents.

*/

const Matrix  Transform::_identity = Matrix::identity();

/*-------------------------------------------------------------------------*/
/*                               Sync                                      */
#include <iomanip>
void Transform::changed(BitVector whichField, UInt32 origin)
{
    // amz removed this "if", the vrml anitmation from worker.wrl in asVisualizationTest didn't work
    // anymore!
    static const Matrix identityMatrix = Matrix::identity();
    // epsilon test of euqality
    if (getMatrix().equals(identityMatrix, osg::Eps)) //if (memcmp(_sfMatrix.getValue().getValues(), identityMatrix.getValues(), sizeof(Matrix)) == 0)
    {
        _sfIsIdentity.setValue(true);
    }
    else
    {
        _sfIsIdentity.setValue(false);
    }

    if(whichField & (MatrixFieldMask|IsIdentityFieldMask))
    {
        if(whichField != NodeCore::ParentsFieldMask)
        {
            invalidateVolume();
            // we need to invalidate the volume of any associated core, otherwise the bounding box is not updated correctly
            if(getAssociatedCore() != osg::NullFC)
                getAssociatedCore()->invalidateVolume();
        }
    }

    Inherited::changed(whichField, origin);
}

/*-------------------------------------------------------------------------*/
/*                               Helper                                    */


void Transform::accumulateMatrix(Matrix &result)
{
    if(!isIdentity()) // only multiply if we don�t have an identity matrix
        result.mult(getMatrix());
}

void Transform::adjustVolume(Volume &volume)
{
    volume.transform(_sfMatrix.getValue());
}

/*-------------------------------------------------------------------------*/
/*                                Dump                                     */

void Transform::dump(      UInt32    uiIndent,
                     const BitVector bvFlags) const
{
   Inherited::dump(uiIndent, bvFlags);
}

/*-------------------------------------------------------------------------*/
/*                            Constructors                                 */

Transform::Transform(void) :
    Inherited(),
    m_core(NullFC)
{
}

Transform::Transform(const Transform &source) :
    Inherited(source),
    m_core(source.m_core)
{
}

/*-------------------------------------------------------------------------*/
/*                             Destructor                                  */

Transform::~Transform(void)
{
}




/*-------------------------------------------------------------------------*/
/*                            Intersect                                    */

Action::ResultE Transform::intersectEnter(Action *action)
{
    // Use parent class for trivial reject
    if(Inherited::intersect(action) == Action::Skip)
        return Action::Skip;

    // Need to check children
    IntersectAction *ia = dynamic_cast<IntersectAction *>(action);
    Matrix           m  = this->getMatrix();

    m.invert();

    Pnt3f pos;
    Vec3f dir;

#ifndef OSG_2_PREP
    m.multFullMatrixPnt(ia->getLine().getPosition (), pos);
    m.multMatrixVec    (ia->getLine().getDirection(), dir);
#else
    m.multFull(ia->getLine().getPosition (), pos);
    m.mult    (ia->getLine().getDirection(), dir);
#endif

    ia->setLine(Line(pos, dir), ia->getMaxDist());
    ia->scale(dir.length());

    return Action::Continue;
}

Action::ResultE Transform::intersectLeave(Action *action)
{
    IntersectAction *ia = dynamic_cast<IntersectAction *>(action);
    Matrix           m  = this->getMatrix();

    Pnt3f pos;
    Vec3f dir;

#ifndef OSG_2_PREP
    m.multFullMatrixPnt(ia->getLine().getPosition (), pos);
    m.multMatrixVec    (ia->getLine().getDirection(), dir);
#else
    m.multFull(ia->getLine().getPosition (), pos);
    m.mult    (ia->getLine().getDirection(), dir);
#endif

    ia->setLine(Line(pos, dir), ia->getMaxDist());
    ia->scale(dir.length());

    return Action::Continue;
}


/*-------------------------------------------------------------------------*/
/*                                Init                                     */

void Transform::initMethod (void)
{

    IntersectAction::registerEnterDefault(getClassType(),
                                     std::bind(reinterpret_cast<Action::Callback>(&Transform::intersectEnter),
                                               std::placeholders::_1, std::placeholders::_2));
    IntersectAction::registerLeaveDefault(getClassType(),
                                     std::bind(reinterpret_cast<Action::Callback>(&Transform::intersectLeave),
                                               std::placeholders::_1, std::placeholders::_2));
}


/*-------------------------------------------------------------------------*/
/*                              cvs id's                                   */

#ifdef __sgi
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp[] = "@(#)$Id: $";
    static Char8 cvsid_hpp[] = OSGTRANSFORM_HEADER_CVSID;
    static Char8 cvsid_inl[] = OSGTRANSFORM_INLINE_CVSID;
}
