/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGTRANSFORM3D_H_
#define _OSGTRANSFORM3D_H_
#pragma once
// version changes:
// 0.0 to 17.5: From project version 17.0 the visibility options for the area lights have changeed (VRED-6696)
// 17.5 to 18.5: Depth of field calculation has changed (VRED-6490)
// 18.5 to 19.5: Volume bounding box calculation has changed (VRED-22740)
// 19.5 to 20.5: Blend mode handling has changed. There is now a dedicated on/off (VRED-27838)
#ifndef CURRENT_TRANSFORM3D_VERSION
#define CURRENT_TRANSFORM3D_VERSION 20.5
#endif

#include <OSGConfig.h>

#include <OSGTransform3DBase.h>

OSG_BEGIN_NAMESPACE

/*! \brief Transform3D class. See \ref
           PageSystemTransform3D for a description.
*/

class OSG_SYSTEMLIB_DLLMAPPING Transform3D : public Transform3DBase
{
  private:

    typedef Transform3DBase Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    enum
    {
        // currently we do not have any transform flags.
        NextFlagId = 0
    };

    enum
    {
        kDefaultRotationMode = 0,
        kLegacyRotationMode = 1,
        kMayaRotationMode = 2
    };

    void	addFlag(UInt64 flag);
    void	subFlag(UInt64 flag);
    bool    hasFlag(UInt64 flag) const;

    virtual void onCreate      (const FieldContainer *source = NULL);

    /*---------------------------------------------------------------------*/
    /*! \name                      Sync                                    */
    /*! \{                                                                 */

    virtual void changed(BitVector  whichField,
                         UInt32     origin    );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Access                                    */
    /*! \{                                                                 */

#if 0
    inline
    void    setEulerRotation(const Vec3f& value);
    inline
    void    setEulerRotationOrientation(const Vec3f& value);
    inline
    void    setEulerRotationOrder(const std::string& value);
#else
    inline
    void    setRotationAsQuaternion(const Quaternion& value);
    inline
    void    setRotationOrientationAsQuaternion(const Quaternion& value);
#endif

    void	reset(void);

    Matrix	getPivotMatrix() const;

    virtual void updateVersion();

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     Output                                   */
    /*! \{                                                                 */

    virtual void dump(      UInt32     uiIndent = 0,
                      const BitVector  bvFlags  = 0) const;

    static BitVector getCombinedTransformAttributesMask();

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    // Variables should all be in Transform3DBase.

    /*---------------------------------------------------------------------*/
    /*! \name                  Constructors                                */
    /*! \{                                                                 */

    Transform3D(void);
    Transform3D(const Transform3D &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~Transform3D(void);

    /*! \}                                                                 */

    /**
     * @brief I moved this functions to protected so that they can not be
     *        used anymore. Use setRotationAsQuaternion respectively
     *        setRotationOrientationAsQuaternion instead so that
     *        euler fields get updated correctly.
     */
    inline
    void    setRotation(const Quaternion& value);
    inline
    void    setRotationOrientation(const Quaternion& value);

    static void initMethod(void);


    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;
    friend class Transform3DBase;

    Matrix  computeFinalMatrix();
    
public:
    void setTransformLimits(const TransformLimitsPtr &value);

    void setRotationAsEuler(const Vec3f& euler);
    void setRotationOrientationAsEuler(const Vec3f& euler);
    void setRotationOrderAsEuler(const std::string& euler);

    void    updateQuatByEuler(void);
    void    updateQuatOrientByEuler(void);
    Quaternion  convertEulerToQuat(const Vec3f& euler, bool addOrientation);

    void    updateEulerByQuat(void);
    void    updateEulerByQuatOrient(void);
    Vec3f   convertQuatToEuler(const Quaternion& value, bool addOrientation);

    bool    getRotationDirectionValues(Vec3f &dir, Int32 &axis);
    void    resetRotationDirection();

    void    setRotationDirection(const Vec3f &dir, Int32 axis);
    Vec3f   getRotationDirection(Int32 axis);
    Vec3f   updateRotationDirection(UInt32 axis, Real32 length);
    void    updateRotationDirectionVector();

    // prohibit default functions (move to 'public' if you need one)
    void syncWith( const Transform3DPtr& pOther, const BitVector& whichField);

    void operator =(const Transform3D &source);
    static Matrix computeFinalMatrix(
            const Vec3f &translation,
            const Vec3f &scale,
            const Quaternion &rotation,
            const Quaternion &rotationOrientation,
            const Pnt3f &rotatePivot,
            const Vec3f &rotatePivotTranslation,
            const Pnt3f &scalePivot,
            const Vec3f &scalePivotTranslation,
            const Vec3f &shear,
            const UInt32 &rotationMode);

    bool equals( const Transform3DPtr& other, const float tolerance = 1.e-6f) const;
};

typedef Transform3D *Transform3DP;

OSG_END_NAMESPACE

#include <OSGTransform3DBase.inl>
#include <OSGTransform3D.inl>

#define OSGTRANSFORM3D_HEADER_CVSID "@(#)$Id: FCTemplate_h.h,v 1.23 2005/03/05 11:27:26 dirk Exp $"

#endif /* _OSGTRANSFORM3D_H_ */
