/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE

#if 0

inline
void Transform3D::setEulerRotation(const Vec3f& value)
{
    _sfEulerRotation.setValue(value);
    Quaternion q = convertEulerToQuat(value, true);
    _sfRotation.setValue(q);
}

inline
void Transform3D::setEulerRotationOrientation(const Vec3f& value)
{
    _sfEulerRotationOrientation.setValue(value);
    Quaternion q = convertEulerToQuat(value, false);
    _sfRotationOrientation.setValue(q);
    Quaternion q2 = convertEulerToQuat(_sfEulerRotation.getValue(), true);
    _sfRotation.setValue(q2);
}

inline
void Transform3D::setEulerRotationOrder(const std::string& value)
{
    _sfEulerRotationOrder.setValue(value);
    Quaternion q = convertEulerToQuat(_sfEulerRotationOrientation.getValue(), false);
    _sfRotationOrientation.setValue(q);
    Quaternion q2 = convertEulerToQuat(_sfEulerRotation.getValue(), true);
    _sfRotation.setValue(q2);
}

#else

inline
void Transform3D::setRotationAsQuaternion(const Quaternion& value)
{
    Transform3DPtr thisPtr(*this);
    beginEditCP(thisPtr, Transform3D::RotationFieldMask | Transform3D::EulerRotationFieldMask);
    _sfRotation.setValue(value);
    Vec3f euler = convertQuatToEuler(value, true);
    _sfEulerRotation.setValue(euler);
    endEditCP(thisPtr, Transform3D::RotationFieldMask | Transform3D::EulerRotationFieldMask);
}

inline
void Transform3D::setRotationOrientationAsQuaternion(const Quaternion& value)
{
    Transform3DPtr thisPtr(*this);
    beginEditCP(thisPtr, Transform3D::RotationOrientationFieldMask | Transform3D::EulerRotationOrientationFieldMask| Transform3D::EulerRotationFieldMask);
    _sfRotationOrientation.setValue(value);
    updateRotationDirectionVector();

    Vec3f euler = convertQuatToEuler(value, false);
    _sfEulerRotationOrientation.setValue(euler);

    Vec3f euler2 = convertQuatToEuler(_sfRotation.getValue(), true);
    _sfEulerRotation.setValue(euler2);
    endEditCP(thisPtr, Transform3D::RotationOrientationFieldMask | Transform3D::EulerRotationOrientationFieldMask| Transform3D::EulerRotationFieldMask);
}

inline
void Transform3D::setRotationAsEuler(const Vec3f& euler)
{
    Transform3DPtr thisPtr(*this);

    beginEditCP(thisPtr, Transform3D::RotationFieldMask | Transform3D::EulerRotationFieldMask);
    setEulerRotation( euler);
    updateQuatByEuler();
    endEditCP(thisPtr, Transform3D::RotationFieldMask | Transform3D::EulerRotationFieldMask);
}

inline
void Transform3D::setRotationOrientationAsEuler(const Vec3f& euler)
{
    Transform3DPtr thisPtr(*this);

    beginEditCP(thisPtr, Transform3D::RotationFieldMask | Transform3D::RotationOrientationFieldMask | Transform3D::EulerRotationOrientationFieldMask);
    setEulerRotationOrientation( euler);
    updateQuatOrientByEuler();
    updateQuatByEuler();
    endEditCP(thisPtr, Transform3D::RotationFieldMask | Transform3D::RotationOrientationFieldMask | Transform3D::EulerRotationOrientationFieldMask);
}

inline
void Transform3D::setRotationOrderAsEuler(const std::string& order)
{
    Transform3DPtr thisPtr(*this);

    beginEditCP(thisPtr, Transform3D::RotationFieldMask | Transform3D::EulerRotationFieldMask |
                         Transform3D::RotationOrientationFieldMask | Transform3D::EulerRotationOrientationFieldMask);
    setEulerRotationOrder( order);
    updateQuatOrientByEuler();
    updateQuatByEuler();
    endEditCP(thisPtr, Transform3D::RotationFieldMask | Transform3D::EulerRotationFieldMask |
                       Transform3D::RotationOrientationFieldMask | Transform3D::EulerRotationOrientationFieldMask);
}

//! Set the value of the Transform3D::_sfRotation field.
inline
void Transform3D::setRotation(const Quaternion &value)
{
    _sfRotation.setValue(value);
}

//! Set the value of the Transform3D::_sfRotationOrientation field.
inline
void Transform3D::setRotationOrientation(const Quaternion &value)
{
    _sfRotationOrientation.setValue(value);
    updateRotationDirectionVector();
}

inline
void Transform3D::setTransformLimits(const TransformLimitsPtr &value)
{
    setRefdCP(_sfTransformLimits.getValue(), value);
}

#endif

OSG_END_NAMESPACE

#define OSGTRANSFORM3D_INLINE_CVSID "@(#)$Id: FCTemplate_inl.h,v 1.8 2002/12/04 14:22:22 dirk Exp $"

