/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGTransformLimits_H_
#define _OSGTransformLimits_H_
#ifdef __sgi
#pragma once
#endif

#include <OSGConfig.h>

#include <OSGTransformLimitsBase.h>

OSG_BEGIN_NAMESPACE

/*! \brief TransformLimits class. See \ref 
           PageSystemTransformLimits for a description.
*/

class OSG_SYSTEMLIB_DLLMAPPING TransformLimits : public TransformLimitsBase
{
  private:

    typedef TransformLimitsBase Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    /*---------------------------------------------------------------------*/
    /*! \name                      Sync                                    */
    /*! \{                                                                 */

    virtual void changed(BitVector  whichField, 
                         UInt32     origin    );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     Output                                   */
    /*! \{                                                                 */

    virtual void dump(      UInt32     uiIndent = 0, 
                      const BitVector  bvFlags  = 0) const;

    /*! \}                                                                 */

    // translation
    bool hasTranslationLimits() const;
    bool limitTranslation(osg::Vec3f &translation) const;
    bool limitTranslation(osg::Matrix &transform) const;

    // rotation
    bool hasRotationLimits() const;
    bool limitEulerRotation(osg::Vec3f &euler) const;
    float limitRotation(float value, bool useMin, float min, bool useMax, float max) const;

    // scaling
    bool hasScalingLimits() const;
    bool limitScaling(osg::Vec3f &scaling) const;

    // generic helper
    float clamp(float value, bool useMin, float min, bool useMax, float max) const;

    //void limitNodeTransformation(osg::NodePtr const& node);

    /*---------------------------------------------------------------------*/
    /*! \name                     Callback                                 */
    /*! \{                                                                 */

    typedef void (*LimitsChangedCallback)();
    static void setLimitsChangedCallback(LimitsChangedCallback callback);

    /*! \}                                                                 */

    /*=========================  PROTECTED  ===============================*/
  protected:

    // Variables should all be in TransformLimitsBase.

    /*---------------------------------------------------------------------*/
    /*! \name                  Constructors                                */
    /*! \{                                                                 */

    TransformLimits(void);
    TransformLimits(const TransformLimits &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~TransformLimits(void); 

    /*! \}                                                                 */
    
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;
    friend class TransformLimitsBase;

    static void initMethod(void);

    static LimitsChangedCallback s_limitsChangedCallback;

    // prohibit default functions (move to 'public' if you need one)

    void operator =(const TransformLimits &source);
};

typedef TransformLimits *TransformLimitsP;

OSG_END_NAMESPACE

#include <OSGTransformLimitsBase.inl>

#define OSGTransformLimits_HEADER_CVSID "@(#)$Id: FCTemplate_h.h,v 1.23 2005/03/05 11:27:26 dirk Exp $"

#endif /* _OSGTransformLimits_H_ */
