/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE

inline
UInt32 SHLChunk::getStaticClassId(void)
{
    return getStaticClass()->getId();
}

inline
const StateChunkClass *SHLChunk::getStaticClass(void)
{
    return &SHLChunk::_class;
}

inline Int32 SHLChunk::getUniformBlockSize()
{
    return s_uniformBlockSize;
}

inline
bool SHLChunk::getStereoViewRenderingEnabled()
{
    return s_hasStereoViewRenderingSupport;
}

inline
bool SHLChunk::getLensMatchedShadingEnabled()
{
	return s_hasLensMatchedShadingSupport;
}

inline
bool SHLChunk::getUseBindlessShadowTextures()
{
	return s_useBindlessShadowTextures;
}

inline
bool SHLChunk::getFogEnabled()
{
	return true; //s_useFog;
}

inline
void SHLChunk::setFogEnabled(const bool on)
{
	s_useFog = on;
}

inline
bool SHLChunk::getStereoViewRendering() const
{
    return m_stereoViewRendering;
}

inline
void SHLChunk::setStereoViewRendering(const bool on)
{
    m_stereoViewRendering = on;
}

inline
bool SHLChunk::getLensMatchedShadingRendering() const
{
	return m_lensMatchedShadingRendering;
}

inline
void SHLChunk::setLensMatchedShadingRendering(const bool on)
{
	m_lensMatchedShadingRendering = on;
}

inline
bool SHLChunk::getSingleViewRenderingOnly() const
{
    return m_singleViewRenderingOnly;
}

inline
void SHLChunk::setSingleViewRenderingOnly(const bool on)
{
    m_singleViewRenderingOnly = on;
}

OSG_END_NAMESPACE

#define OSGSHLCHUNK_INLINE_CVSID "@(#)$Id: OSGSHLChunk.inl,v 1.5 2007/03/09 18:11:48 a-m-z Exp $"
