/*!
 * \class DepthTestChunk
 * \brief
 * \author Andreas Zieringer VREC GmbH
 */

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include <OSGGL.h>


#include <OSGWindow.h>
#include <OSGDrawActionBase.h>

#include "OSGDepthTestChunk.h"


OSG_USING_NAMESPACE

/***************************************************************************\
 *                           Class variables                               *
\***************************************************************************/

StateChunkClass DepthTestChunk::_class("DepthTest");

/***************************************************************************\
 *                           Class methods                                 *
\***************************************************************************/

void DepthTestChunk::initMethod (void)
{
}

/***************************************************************************\
 *                           Instance methods                              *
\***************************************************************************/

/*-------------------------------------------------------------------------*\
 -  private                                                                 -
\*-------------------------------------------------------------------------*/

DepthTestChunk::DepthTestChunk(void) :
    Inherited(),
    _func(GL_GEQUAL)
{
}

DepthTestChunk::DepthTestChunk(const DepthTestChunk &source) :
    Inherited(source),
    _func(source._func)
{
}

DepthTestChunk::~DepthTestChunk(void)
{
}

/*------------------------- Chunk Class Access ---------------------------*/

const StateChunkClass *DepthTestChunk::getClass(void) const
{
    return &_class;
}

/*------------------------------- Sync -----------------------------------*/

void DepthTestChunk::changed(BitVector whichField, UInt32 origin)
{
    Inherited::changed(whichField, origin);
}

/*------------------------------ Output ----------------------------------*/

void DepthTestChunk::dump(      UInt32    , 
                         const BitVector ) const
{
    SLOG << "Dump DepthTestChunk NI" << std::endl;
}

/*------------------------------ State ------------------------------------*/

void DepthTestChunk::activate ( DrawActionBase * action, UInt32 idx )
{
    pushGLDepthFunc();
    setGLDepthFunc(getDepthFunc());
}

void DepthTestChunk::deactivate ( DrawActionBase * action, UInt32 idx )
{
    popGLDepthFunc();
}


/*-------------------------- Comparison -----------------------------------*/


bool DepthTestChunk::operator <(const StateChunk &other) const
{
    return this < &other;
}

bool DepthTestChunk::operator ==(const StateChunk &other) const
{
    DepthTestChunk const *tother = 
                dynamic_cast<DepthTestChunk const*>(&other);

    if(!tother)
        return false;

    if(tother == this)
        return true;

    if(getDepthFunc() != tother->getDepthFunc())
        return false;

    return true;
}

bool DepthTestChunk::operator !=(const StateChunk &other) const
{
    return !(*this == other);
}

