/*!
 * \class DepthTestChunk
 * \brief
 * \author Andreas Zieringer VREC GmbH
 */

#ifndef _OSGDEPTHTESTCHUNK_H_
#define _OSGDEPTHTESTCHUNK_H_
#pragma once

//----------------------------------------------------------------------------
//  Includes
//----------------------------------------------------------------------------

#include <OSGConfig.h>

#include <OSGDepthTestChunkBase.h>

//----------------------------------------------------------------------------
//  namespaces
//----------------------------------------------------------------------------

OSG_BEGIN_NAMESPACE

/*! \brief State chunk for automatic cubetexture coordinate transformations. 
*/

class OSG_SYSTEMLIB_DLLMAPPING DepthTestChunk : public DepthTestChunkBase
{
    /*==========================  PUBLIC  =================================*/
  public:

    /*---------------------------------------------------------------------*/
    /*! \name                 Chunk Class Access                           */
    /*! \{                                                                 */

           virtual const StateChunkClass * getClass         (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name              Static Chunk Class Access                       */
    /*! \{                                                                 */

    inline static        UInt32            getStaticClassId (void);
    inline static  const StateChunkClass * getStaticClass   (void);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                      Sync                                    */
    /*! \{                                                                 */

    virtual void changed(BitVector whichField, 
                         UInt32    origin    );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                      State                                   */
    /*! \{                                                                 */

    virtual void activate   ( DrawActionBase * action, UInt32 index = 0 );

    virtual void deactivate ( DrawActionBase * action, UInt32 index = 0 );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Comparison                                */
    /*! \{                                                                 */

    virtual bool operator <  (const StateChunk &other) const;

    virtual bool operator == (const StateChunk &other) const;
    virtual bool operator != (const StateChunk &other) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     Output                                   */
    /*! \{                                                                 */

    virtual void dump(      UInt32     uiIndent = 0, 
                      const BitVector  bvFlags  = 0) const;

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    // Variables should all be in CubeTextureTransformChunkBase.

    /*---------------------------------------------------------------------*/
    /*! \name                  Constructors                                */
    /*! \{                                                                 */

    DepthTestChunk(void);
    DepthTestChunk(const DepthTestChunk &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~DepthTestChunk(void); 

    /*! \}                                                                 */
    
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;
    friend class DepthTestChunkBase;

    typedef DepthTestChunkBase Inherited;

    static void initMethod(void);
    
    // class. Used for indexing in State
    static StateChunkClass _class;
   
    // prohibit default functions (move to 'public' if you need one)

    void operator =(const DepthTestChunk &source);

    OSGGLint _func;
};

typedef DepthTestChunk *DepthTestChunkP;

OSG_END_NAMESPACE

#include <OSGDepthTestChunkBase.inl>
#include <OSGDepthTestChunk.inl>

#endif /* _OSGDEPTHTESTCHUNK_H_ */
