/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include <OSGGLEXT.h>

#include "OSGDrawActionBase.h"
#include "OSGWindow.h"

#include "OSGPointChunk.h"

OSG_USING_NAMESPACE

/*! \class osg::PointChunk
    \ingroup GrpSystemState

See \ref PageSystemPointChunk for a description. 

This chunk wraps glPointSize() (osg::PointChunk::_sfSize) and
glEnable(GL_POINT_SMOOTH) (osg::PointChunk::_sfSmooth). It encompasses the
ARB_point_parameters extension (osg::PointChunk::_sfMinSize, 
osg::PointChunk::_sfMaxSize, osg::PointChunk::_sfFadeThreshold, 
osg::PointChunk::_sfConstantAttenuation, 
osg::PointChunk::_sfLinearAttenuation,
osg::PointChunk::_sfQuadraticAttenuation) and NV_point_sprite
(osg::PointChunk::_sfSprite, osg::PointChunk::_sfRMode).

*/


/***************************************************************************\
 *                           Class variables                               *
\***************************************************************************/

StateChunkClass PointChunk::_class("Point");

UInt32 PointChunk::_arbPointParameters;
UInt32 PointChunk::_nvPointSprite;
UInt32 PointChunk::_funcPointParameterf;
UInt32 PointChunk::_funcPointParameterfv;

/***************************************************************************\
 *                           Class methods                                 *
\***************************************************************************/

void PointChunk::initMethod (void)
{
}

/***************************************************************************\
 *                           Instance methods                              *
\***************************************************************************/

/*-------------------------------------------------------------------------*\
 -  private                                                                 -
\*-------------------------------------------------------------------------*/

/*----------------------- constructors & destructors ----------------------*/


#ifndef GL_VERSION_1_4
#  define GL_FUNC_POINT_PARAMETERF    OSG_DLSYM_UNDERSCORE"glPointParameterfEXT"
#  define GL_FUNC_POINT_PARAMETERFV   OSG_DLSYM_UNDERSCORE"glPointParameterfvEXT"
#else
#  define GL_FUNC_POINT_PARAMETERF    OSG_DLSYM_UNDERSCORE"glPointParameterf"
#  define GL_FUNC_POINT_PARAMETERFV   OSG_DLSYM_UNDERSCORE"glPointParameterfv"
#endif


PointChunk::PointChunk(void) :
    Inherited()
{
    _arbPointParameters   =
        Window::registerExtension("GL_EXT_point_parameters");
    _nvPointSprite        =
        Window::registerExtension("GL_NV_point_sprite");
    _funcPointParameterf  = Window::registerFunction(
            GL_FUNC_POINT_PARAMETERF,  _arbPointParameters, 0x0104);
    _funcPointParameterfv = Window::registerFunction(
            GL_FUNC_POINT_PARAMETERFV, _arbPointParameters, 0x0104);
}

PointChunk::PointChunk(const PointChunk &source) :
    Inherited(source)
{
}

PointChunk::~PointChunk(void)
{
}

/*------------------------- Chunk Class Access ---------------------------*/

const StateChunkClass *PointChunk::getClass(void) const
{
    return &_class;
}

/*----------------------------- class specific ----------------------------*/

void PointChunk::changed(BitVector whichField, UInt32 origin)
{
    Inherited::changed(whichField, origin);
}

void PointChunk::dump(      UInt32    , 
                         const BitVector ) const
{
    SLOG << "Dump PointChunk NI" << std::endl;
}

/*------------------------------ State ------------------------------------*/

void PointChunk::activate(DrawActionBase *action, UInt32)
{
    if(getSize() != 1.f)
        glPointSize(getSize());
}

void PointChunk::deactivate ( DrawActionBase *action, UInt32 )
{
    if(getSize() != 1.f)
        glPointSize(1.f);
}

/*-------------------------- Comparison -----------------------------------*/

bool PointChunk::isTransparent(void) const
{
    return getMinSize() >= 0.f;
}


bool PointChunk::operator < (const StateChunk &other) const
{
    return this < &other;
}

bool PointChunk::operator == (const StateChunk &other) const
{
    PointChunk const *tother = dynamic_cast<PointChunk const*>(&other);

    if(!tother)
        return false;

    if(tother == this)
        return true;

    if(getSize()                    != tother->getSize()                    ||
       getSmooth()                  != tother->getSmooth()                  ||
       getMinSize()                 != tother->getMinSize()                 ||
       getMaxSize()                 != tother->getMaxSize()                 ||
       getConstantAttenuation()     != tother->getConstantAttenuation()     ||
       getLinearAttenuation()       != tother->getLinearAttenuation()       ||
       getQuadraticAttenuation()    != tother->getQuadraticAttenuation()    ||
       getFadeThreshold()           != tother->getFadeThreshold()           ||
       getSprite()                  != tother->getSprite()                  ||
       getRMode()                   != tother->getRMode()
      )
        return false;

    return true;
}

bool PointChunk::operator != (const StateChunk &other) const
{
    return ! (*this == other);
}



/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: $";
    static Char8 cvsid_hpp       [] = OSGPOINTCHUNKBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPOINTCHUNKBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPOINTCHUNKFIELDS_HEADER_CVSID;
}

#ifdef __sgi
#pragma reset woff 1174
#endif

