/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>

#include "OSGConfig.h"

#include <OSGGL.h>

#include "OSGPolygonChunk.h"

OSG_USING_NAMESPACE


/***************************************************************************\
 *                            Description                                  *
\***************************************************************************/

/*! \class osg::PolygonChunk
    \ingroup GrpSystemState

See \ref PageSystemPolygonChunk for details.

The parameters of the following functions are wrapped here: glCullFace()
(osg::PolygonChunk::_sfCullFace), glFrontFace()
(osg::PolygonChunk::_sfFrontFace), glPolygonMode() 
(osg::PolygonChunk::_sfFrontMode, osg::PolygonChunk::_sfBackMode),
glEnable(GL_POLYGON_SMOOTH) (osg::PolygonChunk::_sfSmooth), glPolygonOffset()
(osg::PolygonChunk::_sfOffsetFactor, osg::PolygonChunk::_sfOffsetBias),
glEnable(GL_POLYGON_OFFSET_POINT) (osg::PolygonChunk::_sfOffsetPoint),
glEnable(GL_POLYGON_OFFSET_LINE) (osg::PolygonChunk::_sfOffsetLine),
glEnable(GL_POLYGON_OFFSET_FILL) (osg::PolygonChunk::_sfOffsetFill),
glStipplePattern() and glEnable(GL_POLYGON_STIPPLE)
(osg::PolygonChunk::_sfStipple).
*/

/***************************************************************************\
 *                           Class variables                               *
\***************************************************************************/

StateChunkClass PolygonChunk::_class("Polygon");

/***************************************************************************\
 *                           Class methods                                 *
\***************************************************************************/

void PolygonChunk::initMethod (void)
{
}

/***************************************************************************\
 *                           Instance methods                              *
\***************************************************************************/

/*-------------------------------------------------------------------------*\
 -  private                                                                 -
\*-------------------------------------------------------------------------*/


/*------------- constructors & destructors --------------------------------*/

PolygonChunk::PolygonChunk(void) :
    Inherited()
{
}

PolygonChunk::PolygonChunk(const PolygonChunk &source) :
    Inherited(source)
{
}

PolygonChunk::~PolygonChunk(void)
{
}

/*------------------------- Chunk Class Access ---------------------------*/

const StateChunkClass *PolygonChunk::getClass(void) const
{
    return &_class;
}

/*------------------------------- Sync -----------------------------------*/

void PolygonChunk::changed(BitVector whichField, UInt32 origin)
{
    Inherited::changed(whichField, origin);
}

/*------------------------------ Output ----------------------------------*/

void PolygonChunk::dump(      UInt32    uiIndent,
                        const BitVector bvFlags) const
{
   Inherited::dump(uiIndent, bvFlags);
}


/*------------------------------ State ------------------------------------*/

void PolygonChunk::activate(DrawActionBase *, UInt32)
{
// cullFace

    if(_sfCullFace.getValue() != GL_NONE)
    {
        glCullFace(_sfCullFace.getValue());
        enableGLFlag(GL_CULL_FACE);
    }

// frontFace

    if(_sfFrontFace.getValue() != GL_CCW)
        glFrontFace(_sfFrontFace.getValue());

// smooth

    if(_sfSmooth.getValue()) 
        enableGLFlag(GL_POLYGON_SMOOTH);

// mode
    // Only GL_FRONT_AND_BACK is valid for glPolygonMode
    if (_sfBackMode.getValue() != GL_FILL)
        glPolygonMode(GL_FRONT_AND_BACK, _sfBackMode.getValue());

    if(_sfFrontMode.getValue() != GL_FILL)
        glPolygonMode(GL_FRONT_AND_BACK, _sfFrontMode.getValue());

    
    
// offset
   
    if(_sfOffsetFactor.getValue() != 0.f || _sfOffsetBias.getValue() != 0.f)    
        glPolygonOffset(_sfOffsetFactor.getValue(), _sfOffsetBias.getValue());

    if(_sfOffsetPoint.getValue())    
        enableGLFlag(GL_POLYGON_OFFSET_POINT);

    if(_sfOffsetLine.getValue()) 
        enableGLFlag(GL_POLYGON_OFFSET_LINE);

    if(_sfOffsetFill.getValue()) 
        enableGLFlag(GL_POLYGON_OFFSET_FILL);

}

void PolygonChunk::deactivate(DrawActionBase *, UInt32)
{

// cullFace

    if(_sfCullFace.getValue() != GL_NONE)
        disableGLFlag(GL_CULL_FACE);

// frontFace

    if(_sfFrontFace.getValue() != GL_CCW)
        glFrontFace(GL_CCW);

// smooth

    if(_sfSmooth.getValue())
        disableGLFlag(GL_POLYGON_SMOOTH);

// mode

    if(_sfFrontMode.getValue() != GL_FILL)
        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

    if(_sfBackMode.getValue() != GL_FILL)
        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

// offset

    if(_sfOffsetPoint.getValue())
        disableGLFlag(GL_POLYGON_OFFSET_POINT);

    if(_sfOffsetLine.getValue())
        disableGLFlag(GL_POLYGON_OFFSET_LINE);

    if(_sfOffsetFill.getValue())
        disableGLFlag(GL_POLYGON_OFFSET_FILL);

// stipple is not supported anymore

    //if(_mfStipple.size() == 32)
     //   disableGLFlag(GL_POLYGON_STIPPLE);

}


/*-------------------------- Comparison -----------------------------------*/

bool PolygonChunk::operator <(const StateChunk &other) const
{
    return this < &other;
}

bool PolygonChunk::operator ==(const StateChunk &other) const
{
    PolygonChunk const *tother = dynamic_cast<PolygonChunk const*>(&other);

    if(!tother)
        return false;

    if(tother == this)
        return true;

    if(getCullFace()          != tother->getCullFace()      ||
       getFrontFace()         != tother->getFrontFace()     ||
       getSmooth()            != tother->getSmooth()        ||
       getFrontMode()         != tother->getFrontMode()     ||
       getBackMode()          != tother->getBackMode()      ||
       getOffsetPoint()       != tother->getOffsetPoint()   ||
       getOffsetLine()        != tother->getOffsetLine()    ||
       getOffsetFill()        != tother->getOffsetFill()    ||
       getOffsetFactor()      != tother->getOffsetFactor()  ||
       getOffsetBias()        != tother->getOffsetBias()    ||
       getMFStipple()->size() != tother->getMFStipple()->size()
      )
        return false;

    // would need to compare the whole stipple data
    // cheap trick: if != 0 take as different
    
    if(        getMFStipple()->size() != 0 ||
       tother->getMFStipple()->size() != 0 
      )
        return false;

    return true;
}

bool PolygonChunk::operator !=(const StateChunk &other) const
{
    return !(*this == other);
}

/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: FCTemplate_cpp.h,v 1.13 2002/06/01 10:37:25 vossg Exp $";
    static Char8 cvsid_hpp       [] = OSGPOLYGONCHUNK_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGPOLYGONCHUNK_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGPOLYGONCHUNKFIELDS_HEADER_CVSID;
}

#ifdef __sgi
#pragma reset woff 1174
#endif


