/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/


#include <OSGConfig.h>

#include <OSGImage.h>
#include <OSGTestCubeMaps.h>


OSG_USING_NAMESPACE

/*! 

The textures for CubeMap reflection testing plus a function to set the images.

*/


static unsigned char TestCubeFrontData[800] = {
77, 84, 68, 0, 40, 53, 246, 64, 
25, 7, 0, 16, 0, 16, 0, 1, 
0, 1, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
};

static unsigned char TestCubeBackData[800] = {
77, 84, 68, 0, 40, 53, 246, 64, 
25, 7, 0, 16, 0, 16, 0, 1, 
0, 1, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 0, 0, 0, 
0, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 0, 0, 0, 
0, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 0, 0, 0, 
0, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 0, 0, 0, 
0, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 0, 0, 0, 
0, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 0, 0, 0, 
0, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
};

static unsigned char TestCubeLeftData[800] = {
77, 84, 68, 0, 40, 53, 246, 64, 
25, 7, 0, 16, 0, 16, 0, 1, 
0, 1, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
0, 0, 255, 0, 0, 255, 0, 0, 
255, 0, 0, 255, 0, 0, 255, 0, 
0, 255, 0, 0, 255, 0, 0, 255, 
};

static unsigned char TestCubeRightData[800] = {
77, 84, 68, 0, 40, 53, 246, 64, 
25, 7, 0, 16, 0, 16, 0, 1, 
0, 1, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 255, 255, 0, 255, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 0, 255, 255, 0, 255, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 0, 0, 0, 0, 
0, 0, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 0, 0, 0, 0, 0, 
0, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 0, 0, 0, 0, 
0, 0, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 0, 0, 0, 0, 0, 
0, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 0, 0, 0, 0, 
0, 0, 255, 0, 255, 255, 0, 255, 
0, 0, 0, 0, 0, 0, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 0, 0, 0, 0, 
0, 0, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 0, 0, 
0, 0, 0, 0, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 0, 0, 0, 0, 
0, 0, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 0, 0, 
0, 0, 0, 0, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 0, 0, 0, 0, 
0, 0, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 0, 0, 
0, 0, 0, 0, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
};

static unsigned char TestCubeUpData[800] = {
77, 84, 68, 0, 40, 53, 246, 64, 
25, 7, 0, 16, 0, 16, 0, 1, 
0, 1, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 255, 0, 
255, 255, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 255, 0, 
255, 255, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
};

static unsigned char TestCubeDownData[800] = {
77, 84, 68, 0, 40, 53, 246, 64, 
25, 7, 0, 16, 0, 16, 0, 1, 
0, 1, 0, 1, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 0, 0, 0, 
0, 0, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 0, 
0, 0, 0, 0, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 0, 0, 0, 
0, 0, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 0, 0, 0, 0, 0, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 0, 0, 0, 
0, 0, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 0, 0, 0, 0, 0, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 0, 0, 0, 
0, 0, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 0, 0, 0, 0, 0, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 0, 0, 0, 
0, 0, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 0, 0, 0, 0, 0, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 0, 0, 0, 
0, 0, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 0, 0, 0, 0, 0, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 0, 0, 0, 
0, 0, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 0, 0, 0, 0, 0, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 0, 0, 0, 
0, 0, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 0, 
0, 0, 0, 0, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
0, 255, 255, 0, 255, 255, 0, 255, 
255, 0, 255, 255, 0, 255, 255, 0, 
255, 255, 0, 255, 255, 0, 255, 255, 
};

void osg::setTestCubeImages( TextureChunkPtr chunk )
{
    ImagePtr img;
    
    CubeTextureChunkPtr cchunk = CubeTextureChunkPtr::dcast(chunk);
    
    if(cchunk != NullFC)
    {
        beginEditCP(cchunk, osg::FieldBits::AllFields);

        img = Image::create();
        img->restore(TestCubeFrontData, sizeof(TestCubeFrontData));
        cchunk->setImage(img);

        img = Image::create();
        img->restore(TestCubeBackData, sizeof(TestCubeBackData));
        cchunk->setPosZImage(img);

        img = Image::create();
        img->restore(TestCubeLeftData, sizeof(TestCubeLeftData));
        cchunk->setNegXImage(img);

        img = Image::create();
        img->restore(TestCubeRightData, sizeof(TestCubeRightData));
        cchunk->setPosXImage(img);

        img = Image::create();
        img->restore(TestCubeDownData, sizeof(TestCubeDownData));
        cchunk->setNegYImage(img);

        img = Image::create();
        img->restore(TestCubeUpData, sizeof(TestCubeUpData));
        cchunk->setPosYImage(img);

        endEditCP(cchunk, osg::FieldBits::AllFields);
    }
    else
    {
        img = Image::create();
        img->restore(TestCubeRightData, sizeof(TestCubeRightData));
        
        ImagePtr image = Image::create();
        beginEditCP(image, osg::FieldBits::AllFields);
        
        image->set(img->getPixelFormat(), img->getWidth(), img->getHeight(), 
                        1, 1, 1, 0, NULL, img->getDataType(), true, 6 );
        
        UInt8 *d = image->editData();
        
        memcpy(d, img->getData(), image->getSize(true, true, false));
        d += image->getSize(true, true, false);
        
        img = Image::create();
        img->restore(TestCubeLeftData, sizeof(TestCubeLeftData));
        memcpy(d, img->getData(), image->getSize(true, true, false));
        d += image->getSize(true, true, false);
        
        img = Image::create();
        img->restore(TestCubeUpData, sizeof(TestCubeUpData));
        memcpy(d, img->getData(), image->getSize(true, true, false));
        d += image->getSize(true, true, false);
        
        img = Image::create();
        img->restore(TestCubeDownData, sizeof(TestCubeDownData));
        memcpy(d, img->getData(), image->getSize(true, true, false));
        d += image->getSize(true, true, false);
              
        img = Image::create();
        img->restore(TestCubeFrontData, sizeof(TestCubeFrontData));
        memcpy(d, img->getData(), image->getSize(true, true, false));
        d += image->getSize(true, true, false);
        
        img = Image::create();
        img->restore(TestCubeBackData, sizeof(TestCubeBackData));
        memcpy(d, img->getData(), image->getSize(true, true, false));
        d += image->getSize(true, true, false);   
        
        endEditCP(image, osg::FieldBits::AllFields);
        
        beginEditCP(chunk, osg::FieldBits::AllFields);
        chunk->setImage(image);
        endEditCP(chunk, osg::FieldBits::AllFields);          
    }
 
}
