/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

OSG_BEGIN_NAMESPACE

inline  bool StatElem::isOn(void) const     
{ 
	return _on; 
}

inline  void StatElem::setOn(bool on)      
{ 
	_on = on; 
}

inline  StatElemDescBase * StatElem::getDesc(void) const        
{ 
	return _desc; 
}

/*!
 * \brief Beautifies string with digits. For example "Autodesk: 123456789" -> "Autodesk: 123 456 789"
 * \param string digits, padding string char, int digits width.
 * \return
 */
inline void StatElem::beautifyDigits(std::string &str, const std::string padding_character, const UInt32 digits_width)
{
    int pos = 0;
    std::string::const_iterator it=str.begin();
    while (it!=str.end())
    {
        if (isdigit(*it))
        {
            std::string digits;
            do
            {
                digits += *it;
                it++;
                pos++;
            }while(isdigit(*it));

            const int spaces = (digits.length()-1)/digits_width;
            const int digitLength = digits.length();
            for (int i=1;i<=spaces;i++)
                digits.insert(digitLength-digits_width*i, padding_character);

            str.erase(pos-digitLength, digitLength);
            str.insert(pos-digitLength, digits);
            it += spaces;
            pos += spaces;
            if (pos>=str.length())
                break;
        }
        else
        {
            it++;
            pos++;
        }
    }
}

OSG_END_NAMESPACE

#define OSGSTATELEM_INLINE_CVSID "@(#)$Id: OSGStatElem.inl,v 1.3 2002/01/21 17:38:40 dirk Exp $"
